/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Priority;

public abstract class PrioritizedRunnable
implements Runnable,
Comparable<PrioritizedRunnable> {
    private final Priority priority;
    private final long creationDate;
    protected final String source;

    protected PrioritizedRunnable(Priority priority, String source) {
        this.priority = priority;
        this.source = source;
        this.creationDate = System.nanoTime();
    }

    public long getCreationDateInNanos() {
        return this.creationDate;
    }

    public long getAgeInMillis() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.creationDate, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(PrioritizedRunnable pr) {
        return this.priority.compareTo(pr.priority);
    }

    public Priority priority() {
        return this.priority;
    }

    public String source() {
        return this.source;
    }

    public String toString() {
        return "[" + this.source + "/" + String.valueOf((Object)this.priority) + "]";
    }
}

