/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

public interface RejectableRunnable
extends Runnable {
    default public boolean isForceExecution() {
        return false;
    }

    @Override
    default public void run() {
        try {
            this.doRun();
        }
        catch (Exception t) {
            this.onFailure(t);
        }
        finally {
            this.onAfter();
        }
    }

    default public void onAfter() {
    }

    public void onFailure(Exception var1);

    default public void onRejection(Exception e) {
        this.onFailure(e);
    }

    public void doRun() throws Exception;
}

