/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.MetadataStateFormat;

public final class NodeMetadata
implements Writeable {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    private final String nodeId;
    private final Version nodeVersion;
    public static final MetadataStateFormat<NodeMetadata> FORMAT = new NodeMetadataStateFormat();

    public NodeMetadata(String nodeId, Version nodeVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
    }

    public NodeMetadata(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.nodeVersion = Version.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        Version.writeVersion(this.nodeVersion, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion);
    }

    public String toString() {
        return "NodeMetadata{nodeId='" + this.nodeId + "', nodeVersion=" + String.valueOf(this.nodeVersion) + "}";
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Version nodeVersion() {
        return this.nodeVersion;
    }

    public NodeMetadata upgradeToCurrentVersion() {
        return this.upgradeToVersion(Version.CURRENT);
    }

    NodeMetadata upgradeToVersion(Version upgradeVersion) {
        if (this.nodeVersion.equals(Version.V_EMPTY)) {
            assert (upgradeVersion.onOrAfter(Version.V_4_6_0)) : "version is required in the node metadata from CrateDB 4.6 onwards";
            return new NodeMetadata(this.nodeId, upgradeVersion);
        }
        if (this.nodeVersion.before(upgradeVersion.minimumIndexCompatibilityVersion())) {
            throw new IllegalStateException("cannot upgrade a node from version [" + String.valueOf(this.nodeVersion) + "] directly to version [" + String.valueOf(upgradeVersion) + "]");
        }
        if (upgradeVersion.beforeMajorMinor(this.nodeVersion)) {
            throw new IllegalStateException("cannot downgrade a node from version [" + String.valueOf(this.nodeVersion) + "] to version [" + String.valueOf(upgradeVersion) + "]");
        }
        return this.nodeVersion.equals(upgradeVersion) ? this : new NodeMetadata(this.nodeId, upgradeVersion);
    }

    private static class NodeMetadataStateFormat
    extends MetadataStateFormat<NodeMetadata> {
        private final ObjectParser<Builder, Void> objectParser = new ObjectParser("node_meta_data", false, Builder::new);

        private NodeMetadataStateFormat() {
            super("node-");
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetadata.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetadata.NODE_VERSION_KEY, new String[0]));
        }

        @Override
        public NodeMetadata fromXContent(XContentParser parser) throws IOException {
            return ((Builder)this.objectParser.apply(parser, null)).build();
        }

        @Override
        public NodeMetadata readFrom(StreamInput in) throws IOException {
            return new NodeMetadata(in);
        }
    }

    private static class Builder {
        String nodeId;
        Version nodeVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = Version.fromId(nodeVersionId);
        }

        public NodeMetadata build() {
            Version nodeVersion;
            if (this.nodeVersion == null) {
                assert (Version.CURRENT.onOrAfter(Version.V_4_6_0)) : "version is required in the node metadata from CrateDB 4.6 onwards";
                nodeVersion = Version.V_EMPTY;
            } else {
                nodeVersion = this.nodeVersion;
            }
            return new NodeMetadata(this.nodeId, nodeVersion);
        }
    }
}

