/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.auth.Authentication;
import io.crate.auth.HttpAuthUpstreamHandler;
import io.crate.auth.Protocol;
import io.crate.blob.BlobService;
import io.crate.common.exceptions.Exceptions;
import io.crate.netty.NettyBootstrap;
import io.crate.protocols.ConnectionStats;
import io.crate.protocols.http.HttpBlobHandler;
import io.crate.protocols.http.MainAndStaticFileHandler;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.protocols.ssl.SslSettings;
import io.crate.rest.action.SqlHttpHandler;
import io.crate.role.Roles;
import io.crate.session.Sessions;
import io.crate.types.DataTypes;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfigBuilder;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.netty4.Netty4InboundStatsHandler;
import org.elasticsearch.transport.netty4.Netty4OutboundStatsHandler;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.jetbrains.annotations.Nullable;

public class Netty4HttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final ByteSizeValue MTU = new ByteSizeValue(Long.parseLong(System.getProperty("es.net.mtu", "1500")));
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting<Integer>("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get((Settings)s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt(s, 2, Integer.MAX_VALUE, SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), DataTypes.STRING, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = new Setting<Integer>("http.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors(s)), s -> Setting.parseInt(s, 1, "http.netty.worker_count"), DataTypes.INTEGER, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("http.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final PortsRange port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    protected final int maxCompositeBufferComponents;
    protected final Settings settings;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected final List<Channel> serverChannels = new ArrayList<Channel>();
    private final StatsTracker statsTracker = new StatsTracker();
    @Nullable
    private Netty4InboundStatsHandler inboundStatsHandler;
    @Nullable
    private Netty4OutboundStatsHandler outboundStatsHandler;
    private final Netty4CorsConfig corsConfig;
    private final NodeClient nodeClient;
    private final SslContextProvider sslContextProvider;
    private final BlobService blobService;
    private final Sessions sessions;
    private final Authentication authentication;
    private final Roles roles;
    private final CircuitBreakerService breakerService;
    private EventLoopGroup eventLoopGroup;

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, SslContextProvider sslContextProvider, BlobService blobService, Sessions sessions, Authentication authentication, Roles roles, CircuitBreakerService breakerService, NodeClient nodeClient) {
        this.settings = settings;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.sslContextProvider = sslContextProvider;
        this.blobService = blobService;
        this.sessions = sessions;
        this.authentication = authentication;
        this.roles = roles;
        this.breakerService = breakerService;
        this.nodeClient = nodeClient;
        this.maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.maxChunkSize = HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.resetCookies = HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings);
        this.maxCompositeBufferComponents = SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.detailedErrorsEnabled = HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings);
        this.readTimeoutMillis = Math.toIntExact(HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings).millis());
        ByteSizeValue receivePredictor = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        this.compression = HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings);
        this.compressionLevel = HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings);
        this.pipeliningMaxEvents = HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = Netty4HttpServerTransport.buildCorsConfig(settings);
        this.logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            this.inboundStatsHandler = new Netty4InboundStatsHandler(this.statsTracker, this.logger);
            this.outboundStatsHandler = new Netty4OutboundStatsHandler(this.statsTracker, this.logger);
            this.eventLoopGroup = NettyBootstrap.newEventLoopGroup(this.settings);
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group(this.eventLoopGroup);
            this.serverBootstrap.channel(NettyBootstrap.serverChannel());
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings));
            ByteSizeValue tcpSendBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings);
            if (tcpSendBufferSize.getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            boolean reuseAddress = HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.boundAddress = this.createBoundHttpAddress();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{}", (Object)this.boundAddress);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        List<InetAddress> hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.size());
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = Netty4HttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), new TransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    static Netty4CorsConfig buildCorsConfig(Settings settings) {
        Netty4CorsConfigBuilder builder;
        if (!HttpTransportSettings.SETTING_CORS_ENABLED.get(settings).booleanValue()) {
            return Netty4CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        if (Strings.isNullOrEmpty(origin)) {
            builder = Netty4CorsConfigBuilder.forOrigins(new String[0]);
        } else if (origin.equals("*")) {
            builder = Netty4CorsConfigBuilder.forAnyOrigin();
        } else {
            try {
                Pattern p = RestUtils.checkCorsSettingForRegex(origin);
                builder = p == null ? Netty4CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray(origin)) : Netty4CorsConfigBuilder.forPattern(p);
            }
            catch (PatternSyntaxException e) {
                throw new SettingsException("Bad regex in [" + HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.getKey() + "]: [" + origin + "]", e);
            }
        }
        if (HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings), ",");
        HttpMethod[] methods = (HttpMethod[])Arrays.stream(strMethods).map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
        return builder.allowedRequestMethods(methods).maxAge(HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings).intValue()).allowedRequestHeaders(Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings), ",")).shortCircuit().build();
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                List<Channel> list = this.serverChannels;
                synchronized (list) {
                    ChannelFuture future = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber)).sync();
                    this.serverChannels.add(future.channel());
                    boundSocket.set((InetSocketAddress)future.channel().localAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (!this.serverChannels.isEmpty()) {
                try {
                    Netty4Utils.closeChannels(this.serverChannels);
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
                this.serverChannels.clear();
            }
        }
        if (this.inboundStatsHandler != null) {
            this.inboundStatsHandler.close();
            this.inboundStatsHandler = null;
        }
        if (this.outboundStatsHandler != null) {
            this.outboundStatsHandler.close();
            this.outboundStatsHandler = null;
        }
        if (this.eventLoopGroup != null) {
            Future future = this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            future.awaitUninterruptibly();
            this.eventLoopGroup = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap = null;
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public ConnectionStats stats() {
        return this.statsTracker.stats();
    }

    public Netty4CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.sessions, this.authentication, this.roles, this.breakerService, this.blobService, this.nodeClient, this.settings, this.sslContextProvider);
    }

    public static InetAddress getRemoteAddress(Channel channel) {
        SocketAddress socketAddress = channel.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return isa.getAddress();
        }
        return InetAddresses.forString("127.0.0.1");
    }

    public static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final NodeClient nodeClient;
        private final String nodeName;
        private final Path home;
        private BlobService blobService;
        private final Sessions sessions;
        private final Authentication authentication;
        private final Roles roles;
        private final CircuitBreakerService breakerService;
        private final Settings settings;
        private final SslContextProvider sslContextProvider;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, Sessions sessions, Authentication authentication, Roles roles, CircuitBreakerService breakerService, BlobService blobService, NodeClient nodeClient, Settings settings, SslContextProvider sslContextProvider) {
            this.sessions = sessions;
            this.authentication = authentication;
            this.roles = roles;
            this.breakerService = breakerService;
            this.blobService = blobService;
            this.transport = transport;
            this.nodeClient = nodeClient;
            this.settings = settings;
            this.sslContextProvider = sslContextProvider;
            this.nodeName = Node.NODE_NAME_SETTING.get(settings);
            this.home = PathUtils.get(Environment.PATH_HOME_SETTING.get(settings), new String[0]).normalize();
        }

        public void initChannel(Channel ch) throws Exception {
            SslContext sslContext;
            ChannelPipeline pipeline = ch.pipeline();
            if (SslSettings.isHttpsEnabled(this.settings) && (sslContext = this.sslContextProvider.getServerContext(Protocol.HTTP)) != null) {
                pipeline.addFirst(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
            }
            pipeline.addLast("inbound_stats", (ChannelHandler)this.transport.inboundStatsHandler);
            pipeline.addLast("outbound_stats", (ChannelHandler)this.transport.outboundStatsHandler);
            pipeline.addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            HttpRequestDecoder decoder = new HttpRequestDecoder(Math.toIntExact(this.transport.maxInitialLineLength.getBytes()), Math.toIntExact(this.transport.maxHeaderSize.getBytes()), Math.toIntExact(this.transport.maxChunkSize.getBytes()));
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            pipeline.addLast("decoder", (ChannelHandler)decoder);
            pipeline.addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(Math.toIntExact(this.transport.maxContentLength.getBytes()));
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            pipeline.addLast("chunked", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("auth_handler", (ChannelHandler)new HttpAuthUpstreamHandler(this.settings, this.authentication, this.roles));
            pipeline.addLast("blob_handler", (ChannelHandler)new HttpBlobHandler(this.blobService));
            pipeline.addLast("aggregator", (ChannelHandler)aggregator);
            if (this.transport.compression) {
                pipeline.addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.transport.compressionLevel));
            }
            pipeline.addLast("sql_handler", (ChannelHandler)new SqlHttpHandler(this.settings, this.sessions, this.breakerService::getBreaker, this.roles));
            pipeline.addLast("handler", (ChannelHandler)new MainAndStaticFileHandler(this.nodeName, this.home, this.nodeClient));
            if (HttpTransportSettings.SETTING_CORS_ENABLED.get(this.transport.settings()).booleanValue()) {
                pipeline.addAfter("encoder", "cors", (ChannelHandler)new Netty4CorsHandler(this.transport.getCorsConfig()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Exceptions.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

