/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;

public final class CommitStats
implements Writeable {
    private final Map<String, String> userData;
    private final long generation;
    private final String id;
    private final int numDocs;

    public CommitStats(SegmentInfos segmentInfos) {
        this.userData = Map.copyOf(segmentInfos.getUserData());
        this.generation = segmentInfos.getLastGeneration();
        this.id = Base64.getEncoder().encodeToString(segmentInfos.getId());
        this.numDocs = Lucene.getNumDocs(segmentInfos);
    }

    public CommitStats(StreamInput in) throws IOException {
        HashMap<String, String> builder = new HashMap<String, String>();
        for (int i = in.readVInt(); i > 0; --i) {
            builder.put(in.readString(), in.readString());
        }
        this.userData = Map.copyOf(builder);
        this.generation = in.readLong();
        this.id = in.readOptionalString();
        this.numDocs = in.readInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.userData.size());
        for (Map.Entry<String, String> entry : this.userData.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeLong(this.generation);
        out.writeOptionalString(this.id);
        out.writeInt(this.numDocs);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public String syncId() {
        return this.userData.get("sync_id");
    }

    public int getNumDocs() {
        return this.numDocs;
    }
}

