/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import io.crate.common.collections.Sets;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.ShardId;

class ElasticsearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final Logger logger;
    private final Settings indexSettings;
    private final ShardId shardId;
    private final Set<OnGoingMerge> onGoingMerges = Sets.newConcurrentHashSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);
    private final MergeSchedulerConfig config;

    ElasticsearchConcurrentMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
        this.config = indexSettings.getMergeSchedulerConfig();
        this.shardId = shardId;
        this.indexSettings = indexSettings.getSettings();
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), shardId, new String[0]);
        this.refreshConfig();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    private static String getSegmentName(MergePolicy.OneMerge merge) {
        SegmentCommitInfo mergeInfo = merge.getMergeInfo();
        return mergeInfo != null ? mergeInfo.info.name : "_na_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        long timeNS = System.nanoTime();
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", (Object)ElasticsearchConcurrentMergeScheduler.getSegmentName(merge), (Object)merge.segments.size(), (Object)totalNumDocs, (Object)new ByteSizeValue(totalSizeInBytes), (Object)new ByteSizeValue(merge.estimatedMergeBytes));
        }
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(mergeSource, merge);
        }
        catch (Throwable throwable) {
            long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS));
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            long stoppedMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.STOPPED)));
            long throttledMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.PAUSED)));
            String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled]", ElasticsearchConcurrentMergeScheduler.getSegmentName(merge), TimeValue.timeValueMillis((long)tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis((long)stoppedMS), TimeValue.timeValueMillis((long)throttledMS));
            if (tookMS > 20000L) {
                this.logger.debug("{}", (Object)message);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", (Object)message);
            }
            throw throwable;
        }
        long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS));
        this.onGoingMerges.remove(onGoingMerge);
        this.afterMerge(onGoingMerge);
        long stoppedMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.STOPPED)));
        long throttledMS = TimeValue.nsecToMSec((long)((Long)merge.getMergeProgress().getPauseTimes().get(MergePolicy.OneMergeProgress.PauseReason.PAUSED)));
        String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled]", ElasticsearchConcurrentMergeScheduler.getSegmentName(merge), TimeValue.timeValueMillis((long)tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis((long)stoppedMS), TimeValue.timeValueMillis((long)throttledMS));
        if (tookMS > 20000L) {
            this.logger.debug("{}", (Object)message);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)message);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }

    protected boolean maybeStall(MergeScheduler.MergeSource mergeSource) {
        return true;
    }

    protected ConcurrentMergeScheduler.MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(mergeSource, merge);
        thread.setName(EsExecutors.threadName(this.indexSettings, "[" + this.shardId.getIndexUUID() + "][" + this.shardId.id() + "]: " + thread.getName()));
        return thread;
    }

    void refreshConfig() {
        boolean isEnabled;
        if (this.getMaxMergeCount() != this.config.getMaxMergeCount() || this.getMaxThreadCount() != this.config.getMaxThreadCount()) {
            this.setMaxMergesAndThreads(this.config.getMaxMergeCount(), this.config.getMaxThreadCount());
        }
        boolean bl = isEnabled = this.getIORateLimitMBPerSec() != Double.POSITIVE_INFINITY;
        if (this.config.isAutoThrottle() && !isEnabled) {
            this.enableAutoIOThrottle();
        } else if (!this.config.isAutoThrottle() && isEnabled) {
            this.disableAutoIOThrottle();
        }
    }
}

