/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.recovery;

import io.crate.common.unit.TimeValue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RecoveryStats {
    private final AtomicInteger currentAsSource = new AtomicInteger();
    private final AtomicInteger currentAsTarget = new AtomicInteger();
    private final AtomicLong throttleTimeInNanos = new AtomicLong();

    public void add(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.currentAsSource.addAndGet(recoveryStats.currentAsSource());
            this.currentAsTarget.addAndGet(recoveryStats.currentAsTarget());
        }
        this.addTotals(recoveryStats);
    }

    public void addTotals(RecoveryStats recoveryStats) {
        if (recoveryStats != null) {
            this.throttleTimeInNanos.addAndGet(recoveryStats.throttleTime().nanos());
        }
    }

    public int currentAsSource() {
        return this.currentAsSource.get();
    }

    public int currentAsTarget() {
        return this.currentAsTarget.get();
    }

    public TimeValue throttleTime() {
        return TimeValue.timeValueNanos((long)this.throttleTimeInNanos.get());
    }

    public void incCurrentAsTarget() {
        this.currentAsTarget.incrementAndGet();
    }

    public void decCurrentAsTarget() {
        this.currentAsTarget.decrementAndGet();
    }

    public void incCurrentAsSource() {
        this.currentAsSource.incrementAndGet();
    }

    public void decCurrentAsSource() {
        this.currentAsSource.decrementAndGet();
    }

    public void addThrottleTime(long nanos) {
        this.throttleTimeInNanos.addAndGet(nanos);
    }

    public String toString() {
        return "recoveryStats, currentAsSource [" + this.currentAsSource() + "],currentAsTarget [" + this.currentAsTarget() + "], throttle [" + String.valueOf(this.throttleTime()) + "]";
    }
}

