/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.Index;

public class ShardId
implements Writeable,
Comparable<ShardId> {
    private final Index index;
    private final int shardId;
    private final int hashCode;

    public ShardId(Index index, int shardId) {
        this.index = index;
        this.shardId = shardId;
        this.hashCode = this.computeHashCode();
    }

    public ShardId(String index, String indexUUID, int shardId) {
        this(new Index(index, indexUUID), shardId);
    }

    public ShardId(StreamInput in) throws IOException {
        this.index = new Index(in);
        this.shardId = in.readVInt();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shardId);
    }

    public Index getIndex() {
        return this.index;
    }

    @Deprecated
    public String getIndexName() {
        return this.index.getName();
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public int id() {
        return this.shardId;
    }

    public String toString() {
        return "[" + this.index.getName() + "/" + this.index.getUUID() + "][" + this.shardId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardId shardId1 = (ShardId)o;
        return this.shardId == shardId1.shardId && this.index.equals(shardId1.index);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        return result;
    }

    @Override
    public int compareTo(ShardId o) {
        if (o.id() == this.shardId) {
            int compare = this.index.getUUID().compareTo(o.getIndex().getUUID());
            if (compare != 0) {
                return compare;
            }
            return this.index.getName().compareTo(o.getIndex().getName());
        }
        return Integer.compare(this.shardId, o.id());
    }
}

