/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import io.crate.common.Suppliers;
import io.crate.common.unit.TimeValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.lucene.store.FilterIndexOutput;

final class ByteSizeCachingDirectory
extends FilterDirectory {
    private final Supplier<Long> size;

    private static long estimateSizeInBytes(Directory directory) throws IOException {
        String[] files;
        long estimatedSize = 0L;
        for (String file : files = directory.listAll()) {
            try {
                estimatedSize += directory.fileLength(file);
            }
            catch (FileNotFoundException | AccessDeniedException | NoSuchFileException iOException) {
                // empty catch block
            }
        }
        return estimatedSize;
    }

    ByteSizeCachingDirectory(Directory in, TimeValue refreshInterval) {
        super(in);
        this.size = Suppliers.memoizeWithExpiration(() -> {
            long size;
            try {
                size = ByteSizeCachingDirectory.estimateSizeInBytes(this.getDelegate());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return size;
        }, (long)refreshInterval.duration(), (TimeUnit)refreshInterval.timeUnit());
    }

    Long estimateSizeInBytes() throws IOException {
        try {
            return this.size.get();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createOutput(name, context));
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        return this.wrapIndexOutput(super.createTempOutput(prefix, suffix, context));
    }

    private IndexOutput wrapIndexOutput(IndexOutput out) {
        return new FilterIndexOutput(this, out.toString(), out){

            public void writeBytes(byte[] b, int length) throws IOException {
                super.writeBytes(b, length);
            }

            @Override
            public void writeByte(byte b) throws IOException {
                super.writeByte(b);
            }

            @Override
            public void close() throws IOException {
                super.close();
            }
        };
    }

    public void deleteFile(String name) throws IOException {
        super.deleteFile(name);
    }
}

