/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import io.crate.common.collections.Iterables;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.RefCounted;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.ByteSizeCachingDirectory;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.VerifyingIndexOutput;
import org.elasticsearch.index.translog.Translog;

public class Store
extends AbstractIndexShardComponent
implements Closeable,
RefCounted {
    static final String CODEC = "store";
    static final int CORRUPTED_MARKER_CODEC_VERSION = 2;
    public static final String CORRUPTED_MARKER_NAME_PREFIX = "corrupted_";
    public static final Setting<TimeValue> INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.store.stats_refresh_interval", TimeValue.timeValueSeconds((long)10L), Setting.Property.IndexScope);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final OnClose onClose;
    private final AbstractRefCounted refCounter = new AbstractRefCounted("store"){

        @Override
        protected void closeInternal() {
            Store.this.closeInternal();
        }
    };

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock) {
        this(shardId, indexSettings, directory, shardLock, OnClose.EMPTY);
    }

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, OnClose onClose) {
        super(shardId, indexSettings);
        TimeValue refreshInterval = indexSettings.getValue(INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING);
        this.logger.debug("store stats are refreshed with refresh_interval [{}]", (Object)refreshInterval);
        ByteSizeCachingDirectory sizeCachingDir = new ByteSizeCachingDirectory(directory, refreshInterval);
        this.directory = new StoreDirectory(sizeCachingDir, Loggers.getLogger("index.store.deletes", shardId));
        this.shardLock = shardLock;
        this.onClose = onClose;
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        this.failIfCorrupted();
        try {
            return Store.readSegmentsInfo(null, this.directory());
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            this.markStoreCorrupted((IOException)ex);
            throw ex;
        }
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        assert (commit == null || commit.getDirectory() == directory);
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "commit(" + String.valueOf(commit) + ")", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "commit(" + String.valueOf(commit) + ")", (Throwable)ex);
        }
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        return this.getMetadata(commit, false);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit, boolean lockDirectory) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        assert (!lockDirectory || commit == null) : "IW lock should not be obtained if there is a commit point available";
        java.util.concurrent.locks.Lock lock = lockDirectory ? this.metadataLock.writeLock() : this.metadataLock.readLock();
        lock.lock();
        try {
            MetadataSnapshot metadataSnapshot;
            block12: {
                Closeable ignored = lockDirectory ? this.directory.obtainLock("write.lock") : () -> {};
                try {
                    metadataSnapshot = new MetadataSnapshot(commit, (Directory)this.directory, this.logger);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        this.markStoreCorrupted((IOException)ex);
                        throw ex;
                    }
                }
                ignored.close();
            }
            return metadataSnapshot;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Object[] entries = tempFileMap.entrySet().toArray(new Map.Entry[tempFileMap.size()]);
        ArrayUtil.timSort((Object[])entries, (Comparator)new Comparator<Map.Entry<String, String>>(this){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String left = o1.getValue();
                String right = o2.getValue();
                if (left.startsWith("segments") || right.startsWith("segments")) {
                    if (!left.startsWith("segments")) {
                        return -1;
                    }
                    if (!right.startsWith("segments")) {
                        return 1;
                    }
                }
                return left.compareTo(right);
            }
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory().obtainLock("write.lock");){
            for (Object entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Exception ex) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)origFile), (Throwable)ex);
                }
                this.directory.rename(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public CheckIndex.Status checkIndex(PrintStream out) throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            CheckIndex.Status status;
            try (CheckIndex checkIndex = new CheckIndex((Directory)this.directory);){
                checkIndex.setInfoStream(out);
                status = checkIndex.checkIndex();
            }
            return status;
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats(long reservedBytes) throws IOException {
        this.ensureOpen();
        return new StoreStats(this.directory.estimateSize(), reservedBytes);
    }

    @Override
    public final void incRef() {
        this.refCounter.incRef();
    }

    @Override
    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    @Override
    public final void decRef() {
        this.refCounter.decRef();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
            this.logger.debug("store reference count on close: {}", (Object)this.refCounter.refCount());
        }
    }

    public boolean isClosing() {
        return this.isClosed.get();
    }

    private void closeInternal() {
        try (ShardLock c = this.shardLock;){
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.accept(this.shardLock);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MetadataSnapshot readMetadataSnapshot(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException {
        try (ShardLock lock2 = shardLocker.lock(shardId, "read metadata snapshot", TimeUnit.SECONDS.toMillis(5L));){
            MetadataSnapshot metadataSnapshot;
            try (NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
                Store.failIfCorrupted((Directory)dir);
                metadataSnapshot = new MetadataSnapshot(null, (Directory)dir, logger);
            }
            return metadataSnapshot;
        }
        catch (IndexNotFoundException lock2) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot", (Throwable)ex);
        }
        catch (ShardLockObtainFailedException ex) {
            logger.info(() -> new ParameterizedMessage("{}: failed to obtain shard lock", (Object)shardId), (Throwable)ex);
        }
        return MetadataSnapshot.EMPTY;
    }

    public static boolean canOpenIndex(Logger logger, Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker) throws IOException {
        try {
            Store.tryOpenIndex(indexLocation, shardId, shardLocker, logger);
        }
        catch (Exception ex) {
            logger.trace(() -> new ParameterizedMessage("Can't open index for path [{}]", (Object)indexLocation), (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void tryOpenIndex(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException, ShardLockObtainFailedException {
        try (ShardLock lock = shardLocker.lock(shardId, "open index", TimeUnit.SECONDS.toMillis(5L));
             NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
            Store.failIfCorrupted((Directory)dir);
            SegmentInfos segInfo = Lucene.readSegmentInfos((Directory)dir);
            logger.trace("{} loaded segment info [{}]", (Object)shardId, (Object)segInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetadata metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            if ($assertionsDisabled) return new LuceneVerifyingIndexOutput(metadata, output);
            if (metadata.writtenBy() != null) return new LuceneVerifyingIndexOutput(metadata, output);
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            throw throwable;
        }
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetadata metadata) throws IOException {
        assert (metadata.writtenBy() != null);
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrityNoException(StoreFileMetadata md) {
        return Store.checkIntegrityNoException(md, this.directory());
    }

    public static boolean checkIntegrityNoException(StoreFileMetadata md, Directory directory) {
        try {
            Store.checkIntegrity(md, directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkIntegrity(StoreFileMetadata md, Directory directory) throws IOException {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            if (input.length() != md.length()) {
                throw new CorruptIndexException("expected length=" + md.length() + " != actual length: " + input.length() + " : file truncated?", (DataInput)input);
            }
            String checksum = Store.digestToString(CodecUtil.checksumEntireFile((IndexInput)input));
            if (!checksum.equals(md.checksum())) {
                throw new CorruptIndexException("inconsistent metadata: lucene checksum=" + checksum + ", metadata checksum=" + md.checksum(), (DataInput)input);
            }
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public void removeCorruptionMarker() throws IOException {
        String[] files;
        this.ensureOpen();
        Directory directory = this.directory();
        IOException firstException = null;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try {
                directory.deleteFile(file);
            }
            catch (IOException ex) {
                if (firstException == null) {
                    firstException = ex;
                    continue;
                }
                firstException.addSuppressed(ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted((Directory)this.directory);
    }

    private static void failIfCorrupted(Directory directory) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file);){
                CodecUtil.checkHeader((DataInput)input, (String)CODEC, (int)2, (int)2);
                int size = input.readVInt();
                byte[] buffer = new byte[size];
                input.readBytes(buffer, 0, buffer.length);
                StreamInput in = StreamInput.wrap(buffer);
                Object t = in.readException();
                if (t instanceof CorruptIndexException) {
                    ex.add((CorruptIndexException)((Object)t));
                } else {
                    ex.add(new CorruptIndexException(((Throwable)t).getMessage(), "preexisting_corruption", t));
                }
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            }
        }
        if (!ex.isEmpty()) {
            Exceptions.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetadata) throws IOException {
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.obtainLock("write.lock");){
            for (String existingFile : this.directory.listAll()) {
                if (Store.isAutogenerated(existingFile) || sourceMetadata.contains(existingFile)) continue;
                try {
                    this.directory.deleteFile(reason, existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) {
                        throw new IllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)existingFile), (Throwable)ex);
                }
            }
            this.directory.syncMetaData();
            MetadataSnapshot metadataOrEmpty = this.getMetadata(null);
            this.verifyAfterCleanup(sourceMetadata, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetadata, MetadataSnapshot targetMetadata) {
        RecoveryDiff recoveryDiff = targetMetadata.recoveryDiff(sourceMetadata);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetadata meta : recoveryDiff.different) {
                    StoreFileMetadata remote;
                    StoreFileMetadata local = targetMetadata.get(meta.name());
                    if (local.isSame(remote = sourceMetadata.get(meta.name()))) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", (Object)recoveryDiff);
                    throw new IllegalStateException("local version: " + String.valueOf(local) + " is different from remote version after recovery: " + String.valueOf(remote), null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", (Object)recoveryDiff);
                throw new IllegalStateException("Files are missing on the recovery target: [different=" + String.valueOf(recoveryDiff.different) + ", missing=" + String.valueOf(recoveryDiff.missing) + "]", null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public void beforeClose() {
        this.shardLock.setDetails("closing shard");
    }

    public static boolean isAutogenerated(String name) {
        return "write.lock".equals(name);
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        this.ensureOpen();
        StoreDirectory directory = this.directory;
        for (String file : files) {
            try {
                directory.deleteFile("Store.deleteQuiet", file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(IOException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String corruptionMarkerName = CORRUPTED_MARKER_NAME_PREFIX + UUIDs.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(corruptionMarkerName, IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)output, (String)CODEC, (int)2);
                try (BytesStreamOutput out = new BytesStreamOutput();){
                    out.writeException(exception);
                    BytesReference bytes = out.bytes();
                    output.writeVInt(bytes.length());
                    BytesRef ref = bytes.toBytesRef();
                    output.writeBytes(ref.bytes, ref.offset, ref.length);
                    CodecUtil.writeFooter((IndexOutput)output);
                }
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", (Throwable)ex);
            }
            this.directory().sync(Collections.singleton(corruptionMarkerName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmpty(org.apache.lucene.util.Version luceneVersion) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newEmptyIndexWriter((Directory)this.directory, luceneVersion);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(-1L));
            map.put("max_seq_no", Long.toString(-1L));
            map.put("max_unsafe_auto_id_timestamp", "-1");
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory() throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            Map userData = this.readLastCommittedSegmentsInfo().getUserData();
            long maxSeqNo = Long.parseLong((String)userData.get("max_seq_no"));
            long localCheckpoint = Long.parseLong((String)userData.get("local_checkpoint"));
            this.bootstrapNewHistory(localCheckpoint, maxSeqNo);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory(long localCheckpoint, long maxSeqNo) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newAppendingIndexWriter((Directory)this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(localCheckpoint));
            map.put("max_seq_no", Long.toString(maxSeqNo));
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateIndexWithNewTranslog(String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newAppendingIndexWriter((Directory)this.directory, null);){
            if (translogUUID.equals(Store.getUserData(writer).get("translog_uuid"))) {
                throw new IllegalArgumentException("a new translog uuid can't be equal to existing one. got [" + translogUUID + "]");
            }
            Store.updateCommitData(writer, Collections.singletonMap("translog_uuid", translogUUID));
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnsafeCommits(Path translogPath) throws IOException {
        block10: {
            this.metadataLock.writeLock().lock();
            try {
                List existingCommits = DirectoryReader.listCommits((Directory)this.directory);
                assert (!existingCommits.isEmpty());
                IndexCommit lastIndexCommit = (IndexCommit)existingCommits.get(existingCommits.size() - 1);
                String translogUUID = (String)lastIndexCommit.getUserData().get("translog_uuid");
                long lastSyncedGlobalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID);
                IndexCommit startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(existingCommits, lastSyncedGlobalCheckpoint);
                if (startingIndexCommit.equals((Object)lastIndexCommit)) break block10;
                try (IndexWriter writer = Store.newAppendingIndexWriter((Directory)this.directory, startingIndexCommit);){
                    writer.setLiveCommitData(startingIndexCommit.getUserData().entrySet());
                    writer.commit();
                }
            }
            finally {
                this.metadataLock.writeLock().unlock();
            }
        }
    }

    public Optional<SequenceNumbers.CommitInfo> findSafeIndexCommit(long globalCheckpoint) throws IOException {
        List commits = DirectoryReader.listCommits((Directory)this.directory);
        assert (!commits.isEmpty()) : "no commit found";
        IndexCommit safeCommit = CombinedDeletionPolicy.findSafeCommitPoint(commits, globalCheckpoint);
        SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(safeCommit.getUserData().entrySet());
        if (commitInfo.maxSeqNo <= globalCheckpoint) {
            return Optional.of(commitInfo);
        }
        return Optional.empty();
    }

    private static void updateCommitData(IndexWriter writer, Map<String, String> keysToUpdate) throws IOException {
        Map<String, String> userData = Store.getUserData(writer);
        userData.putAll(keysToUpdate);
        writer.setLiveCommitData(userData.entrySet());
        writer.commit();
    }

    private static Map<String, String> getUserData(IndexWriter writer) {
        HashMap<String, String> userData = new HashMap<String, String>();
        writer.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
        return userData;
    }

    private static IndexWriter newAppendingIndexWriter(Directory dir, IndexCommit commit) throws IOException {
        IndexWriterConfig iwc = Store.newIndexWriterConfig().setIndexCommit(commit).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriter newEmptyIndexWriter(Directory dir, org.apache.lucene.util.Version luceneVersion) throws IOException {
        IndexWriterConfig iwc = Store.newIndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.CREATE).setIndexCreatedVersionMajor(luceneVersion.major);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriterConfig newIndexWriterConfig() {
        return new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE);
    }

    public static interface OnClose
    extends Consumer<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void accept(ShardLock Lock2) {
            }
        };
    }

    static final class StoreDirectory
    extends FilterDirectory {
        private final Logger deletesLogger;

        StoreDirectory(ByteSizeCachingDirectory delegateDirectory, Logger deletesLogger) {
            super((Directory)delegateDirectory);
            this.deletesLogger = deletesLogger;
        }

        Long estimateSize() throws IOException {
            return ((ByteSizeCachingDirectory)this.getDelegate()).estimateSizeInBytes();
        }

        public void close() {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String msg, String name) throws IOException {
            this.deletesLogger.trace("{}: delete file {}", (Object)msg, (Object)name);
            super.deleteFile(name);
        }

        public void deleteFile(String name) throws IOException {
            this.deleteFile("StoreDirectory.deleteFile", name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        public String toString() {
            return "store(" + this.in.toString() + ")";
        }
    }

    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetadata>,
    Writeable {
        private final Map<String, StoreFileMetadata> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private final Map<String, String> commitUserData;
        private final long numDocs;
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String LIV_FILE_EXTENSION = "liv";
        private static final String SEGMENT_INFO_EXTENSION = "si";

        public MetadataSnapshot(Map<String, StoreFileMetadata> metadata, Map<String, String> commitUserData, long numDocs) {
            this.metadata = metadata;
            this.commitUserData = commitUserData;
            this.numDocs = numDocs;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
            this.commitUserData = Collections.emptyMap();
            this.numDocs = 0L;
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            LoadedMetadata loadedMetadata = MetadataSnapshot.loadMetadata(commit, directory, logger);
            this.metadata = loadedMetadata.fileMetadata;
            this.commitUserData = loadedMetadata.userData;
            this.numDocs = loadedMetadata.numDocs;
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        public MetadataSnapshot(StreamInput in) throws IOException {
            int num;
            int size = in.readVInt();
            HashMap<String, StoreFileMetadata> metadata = new HashMap<String, StoreFileMetadata>();
            for (int i = 0; i < size; ++i) {
                StoreFileMetadata meta = new StoreFileMetadata(in);
                metadata.put(meta.name(), meta);
            }
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            for (int i = num = in.readVInt(); i > 0; --i) {
                commitUserData.put(in.readString(), in.readString());
            }
            this.metadata = Collections.unmodifiableMap(metadata);
            this.commitUserData = Collections.unmodifiableMap(commitUserData);
            this.numDocs = in.readLong();
            assert (metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.metadata.size());
            for (StoreFileMetadata storeFileMetadata : this) {
                storeFileMetadata.writeTo(out);
            }
            out.writeVInt(this.commitUserData.size());
            for (Map.Entry entry : this.commitUserData.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
            out.writeLong(this.numDocs);
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        static LoadedMetadata loadMetadata(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            long numDocs;
            HashMap<String, StoreFileMetadata> builder = new HashMap<String, StoreFileMetadata>();
            HashMap commitUserDataBuilder = new HashMap();
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                numDocs = Lucene.getNumDocs(segmentCommitInfos);
                commitUserDataBuilder.putAll(segmentCommitInfos.getUserData());
                org.apache.lucene.util.Version maxVersion = segmentCommitInfos.getMinSegmentLuceneVersion();
                for (SegmentCommitInfo info : segmentCommitInfos) {
                    org.apache.lucene.util.Version version = info.info.getVersion();
                    if (version == null) {
                        throw new IllegalArgumentException("expected valid version value: " + info.info.toString());
                    }
                    if (version.onOrAfter(maxVersion)) {
                        maxVersion = version;
                    }
                    for (String file : info.files()) {
                        MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension((String)file)));
                    }
                }
                if (maxVersion == null) {
                    maxVersion = Version.CURRENT.minimumIndexCompatibilityVersion().luceneVersion;
                }
                String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException | IndexNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                try {
                    logger.warn(() -> new ParameterizedMessage("failed to build store metadata. checking segment info integrity (with commit [{}])", (Object)(commit == null ? "no" : "yes")), (Throwable)ex);
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException cex) {
                    cex.addSuppressed(ex);
                    throw cex;
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    throw inner;
                }
                throw ex;
            }
            return new LoadedMetadata(Collections.unmodifiableMap(builder), Collections.unmodifiableMap(commitUserDataBuilder), numDocs);
        }

        private static void checksumFromLuceneFile(Directory directory, String file, Map<String, StoreFileMetadata> builder, Logger logger, org.apache.lucene.util.Version version, boolean readFileAsHash) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                long length;
                try {
                    length = in.length();
                    if (length < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length(), (DataInput)in);
                    }
                    if (readFileAsHash) {
                        VerifyingIndexInput verifyingIndexInput = new VerifyingIndexInput(in);
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput((IndexInput)verifyingIndexInput, length), length);
                        checksum = Store.digestToString(verifyingIndexInput.verify());
                    } else {
                        checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)in));
                    }
                }
                catch (Exception ex) {
                    logger.debug(() -> new ParameterizedMessage("Can retrieve checksum from file [{}]", (Object)file), (Throwable)ex);
                    throw ex;
                }
                builder.put(file, new StoreFileMetadata(file, length, checksum, version, fileHash.get()));
            }
        }

        public static void hashFile(BytesRefBuilder fileHash, InputStream in, long size) throws IOException {
            int len = (int)Math.min(0x100000L, size);
            fileHash.grow(len);
            fileHash.setLength(len);
            int readBytes = Streams.readFully(in, fileHash.bytes(), 0, len);
            assert (readBytes == len) : Integer.toString(readBytes) + " != " + Integer.toString(len);
            assert (fileHash.length() == len) : Integer.toString(fileHash.length()) + " != " + Integer.toString(len);
        }

        @Override
        public Iterator<StoreFileMetadata> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetadata get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetadata> asMap() {
            return this.metadata;
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ArrayList identical = new ArrayList();
            ArrayList<StoreFileMetadata> different = new ArrayList<StoreFileMetadata>();
            ArrayList<StoreFileMetadata> missing = new ArrayList<StoreFileMetadata>();
            HashMap<String, ArrayList<Object>> perSegment = new HashMap<String, ArrayList<Object>>();
            ArrayList<Object> perCommitStoreFiles = new ArrayList<Object>();
            for (Object meta : this) {
                String segmentId = IndexFileNames.parseSegmentName((String)((StoreFileMetadata)meta).name());
                String extension = IndexFileNames.getExtension((String)((StoreFileMetadata)meta).name());
                if ("segments".equals(segmentId) || DEL_FILE_EXTENSION.equals(extension) || LIV_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                ArrayList<Object> perSegStoreFiles = (ArrayList<Object>)perSegment.get(segmentId);
                if (perSegStoreFiles == null) {
                    perSegStoreFiles = new ArrayList<Object>();
                    perSegment.put(segmentId, perSegStoreFiles);
                }
                perSegStoreFiles.add(meta);
            }
            ArrayList<StoreFileMetadata> identicalFiles = new ArrayList<StoreFileMetadata>();
            for (List segmentFiles : Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles))) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetadata meta : segmentFiles) {
                    StoreFileMetadata storeFileMetadata = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetadata == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetadata.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
            assert (recoveryDiff.size() == this.metadata.size()) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }

        public Map<String, String> getCommitUserData() {
            return this.commitUserData;
        }

        public String getHistoryUUID() {
            return this.commitUserData.get("history_uuid");
        }

        public String getTranslogUUID() {
            return this.commitUserData.get("translog_uuid");
        }

        public boolean contains(String existingFile) {
            return this.metadata.containsKey(existingFile);
        }

        public StoreFileMetadata getSegmentsFile() {
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.metadata.isEmpty());
            return null;
        }

        private int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }

        public String getSyncId() {
            return this.commitUserData.get("sync_id");
        }

        static class LoadedMetadata {
            final Map<String, StoreFileMetadata> fileMetadata;
            final Map<String, String> userData;
            final long numDocs;

            LoadedMetadata(Map<String, StoreFileMetadata> fileMetadata, Map<String, String> userData, long numDocs) {
                this.fileMetadata = fileMetadata;
                this.userData = userData;
                this.numDocs = numDocs;
            }
        }
    }

    static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetadata metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;
        private final byte[] footerChecksum = new byte[8];

        LuceneVerifyingIndexOutput(StoreFileMetadata metadata, IndexOutput out) {
            super(out);
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            String footerDigest = null;
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                ByteArrayIndexInput indexInput = new ByteArrayIndexInput("checksum", this.footerChecksum);
                footerDigest = Store.digestToString(CodecUtil.readBELong((DataInput)indexInput));
                if (this.metadata.checksum().equals(footerDigest)) {
                    return;
                }
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " footer=" + footerDigest + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
        }

        @Override
        public void writeByte(byte b) throws IOException {
            long writtenBytes;
            if ((writtenBytes = this.writtenBytes++) >= this.checksumPosition) {
                int index;
                if (writtenBytes == this.checksumPosition) {
                    this.readAndCompareChecksum();
                }
                if ((index = Math.toIntExact(writtenBytes - this.checksumPosition)) < this.footerChecksum.length) {
                    this.footerChecksum[index] = b;
                    if (index == this.footerChecksum.length - 1) {
                        this.verify();
                    }
                } else {
                    this.verify();
                    throw new AssertionError((Object)("write past EOF expected length: " + this.metadata.length() + " writtenBytes: " + writtenBytes));
                }
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
            }
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition) {
                for (int i = 0; i < length; ++i) {
                    this.writeByte(b[offset + i]);
                }
            } else {
                this.out.writeBytes(b, offset, length);
                this.writtenBytes += (long)length;
            }
        }
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        VerifyingIndexInput(IndexInput input) {
            this(input, (Checksum)new BufferedChecksum((Checksum)new CRC32()));
        }

        VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + String.valueOf(input) + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else {
                if (this.verifiedPosition > this.getFilePointer()) {
                    this.input.seek(this.verifiedPosition);
                }
                super.seek(pos);
            }
        }

        public void close() throws IOException {
            this.input.close();
        }

        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        public long length() {
            return this.input.length();
        }

        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() throws IOException {
            return CodecUtil.readBELong((DataInput)new ByteArrayDataInput(this.checksum));
        }

        public long verify() throws IOException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum), (DataInput)this);
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetadata> identical;
        public final List<StoreFileMetadata> different;
        public final List<StoreFileMetadata> missing;

        RecoveryDiff(List<StoreFileMetadata> identical, List<StoreFileMetadata> different, List<StoreFileMetadata> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + String.valueOf(this.identical) + ", different=" + String.valueOf(this.different) + ", missing=" + String.valueOf(this.missing) + "}";
        }
    }
}

