/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;

public final class StoreStats
implements Writeable {
    public static final long UNKNOWN_RESERVED_BYTES = -1L;
    public static final Version RESERVED_BYTES_VERSION = Version.V_4_8_0;
    private long sizeInBytes;
    private long reservedSize;

    public StoreStats() {
    }

    public StoreStats(long sizeInBytes, long reservedSize) {
        assert (reservedSize == -1L || reservedSize >= 0L) : reservedSize;
        this.sizeInBytes = sizeInBytes;
        this.reservedSize = reservedSize;
    }

    public StoreStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.reservedSize = in.getVersion().onOrAfter(RESERVED_BYTES_VERSION) ? in.readZLong() : -1L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        if (out.getVersion().onOrAfter(RESERVED_BYTES_VERSION)) {
            out.writeZLong(this.reservedSize);
        }
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.reservedSize = StoreStats.ignoreIfUnknown(this.reservedSize) + StoreStats.ignoreIfUnknown(stats.reservedSize);
    }

    private static long ignoreIfUnknown(long reservedSize) {
        return reservedSize == -1L ? 0L : reservedSize;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getReservedSize() {
        return new ByteSizeValue(this.reservedSize);
    }
}

