/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.KeywordAnalyzerProvider;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.SimpleAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StopAnalyzerProvider;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.WhitespaceAnalyzerProvider;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;
import org.elasticsearch.plugins.AnalysisPlugin;

public final class AnalysisModule {
    private static final IndexSettings NA_INDEX_SETTINGS;
    private static final DeprecationLogger DEPRECATION_LOGGER;
    private final AnalysisRegistry analysisRegistry;

    public AnalysisModule(Environment environment2, List<AnalysisPlugin> plugins) throws IOException {
        Map hunspellDictionaries = MapBuilder.newMapBuilder().putUnique("dictionary", (Iterable)Lists.mapLazy(plugins, AnalysisPlugin::getHunspellDictionaries)).immutableMap();
        HunspellService hunspellService = new HunspellService(environment2.settings(), environment2, hunspellDictionaries);
        Map tokenFilters = MapBuilder.newMapBuilder().putUnique("token_filter", (Object)"stop", StopTokenFilterFactory::new).putUnique("token_filter", (Object)"standard", (indexSettings, environment, name, settings) -> {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("standard_deprecation", "The [standard] token filter name is deprecated and will be removed in a future version.", new Object[0]);
            return new AbstractTokenFilterFactory(this, indexSettings, name, settings){

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return tokenStream;
                }
            };
        }).putUnique("token_filter", (Object)"shingle", ShingleTokenFilterFactory::new).putUnique("token_filter", (Object)"hunspell", AnalysisPlugin.requiresAnalysisSettings((indexSettings, environment, name, settings) -> new HunspellTokenFilterFactory(indexSettings, name, settings, hunspellService))).putUnique("token_filter", (Iterable)Lists.mapLazy(plugins, AnalysisPlugin::getTokenFilters)).immutableMap();
        Map tokenizers = MapBuilder.newMapBuilder().putUnique("tokenizer", (Object)"standard", StandardTokenizerFactory::new).putUnique("tokenizer", (Iterable)Lists.mapLazy(plugins, AnalysisPlugin::getTokenizers)).immutableMap();
        Map analyzers = MapBuilder.newMapBuilder().putUnique("analyzers", (Object)"default", StandardAnalyzerProvider::new).putUnique("analyzers", (Object)"standard", StandardAnalyzerProvider::new).putUnique("analyzers", (Object)"simple", SimpleAnalyzerProvider::new).putUnique("analyzers", (Object)"stop", StopAnalyzerProvider::new).putUnique("analyzers", (Object)"whitespace", WhitespaceAnalyzerProvider::new).putUnique("analyzers", (Object)"keyword", KeywordAnalyzerProvider::new).putUnique("analyzers", (Iterable)Lists.mapLazy(plugins, AnalysisPlugin::getAnalyzers)).immutableMap();
        Map<String, AnalysisProvider<AnalyzerProvider<?>>> normalizers = Map.of();
        Map<String, PreConfiguredCharFilter> preConfiguredCharFilters = AnalysisModule.preConfig("pre-configured char_filter", plugins, AnalysisPlugin::getPreConfiguredCharFilters, PreConfiguredAnalysisComponent::getName);
        Map<String, PreBuiltAnalyzerProviderFactory> preConfiguredAnalyzers = AnalysisModule.preConfig("pre-built analyzer", plugins, AnalysisPlugin::getPreBuiltAnalyzerProviderFactories, PreConfiguredAnalysisComponent::getName);
        this.analysisRegistry = new AnalysisRegistry(environment2, MapBuilder.newMapBuilder().putUnique("char_filter", (Iterable)Lists.mapLazy(plugins, AnalysisPlugin::getCharFilters)).immutableMap(), tokenFilters, tokenizers, analyzers, normalizers, preConfiguredCharFilters, AnalysisModule.setupPreConfiguredTokenFilters(plugins), AnalysisModule.setupPreConfiguredTokenizers(plugins), preConfiguredAnalyzers);
    }

    private static <T> Map<String, T> preConfig(String mapName, List<AnalysisPlugin> plugins, Function<AnalysisPlugin, List<T>> getItems, Function<T, String> getKey) {
        MapBuilder map = MapBuilder.newMapBuilder();
        for (AnalysisPlugin plugin : plugins) {
            List<T> items = getItems.apply(plugin);
            for (T item : items) {
                map.putUnique(mapName, (Object)getKey.apply(item), item);
            }
        }
        return map.immutableMap();
    }

    public AnalysisRegistry getAnalysisRegistry() {
        return this.analysisRegistry;
    }

    static Map<String, PreConfiguredTokenFilter> setupPreConfiguredTokenFilters(List<AnalysisPlugin> plugins) {
        String name = "pre-configured token_filter";
        MapBuilder preConfiguredTokenFilters = MapBuilder.newMapBuilder().putUnique(name, (Object)"lowercase", (Object)PreConfiguredTokenFilter.singleton("lowercase", true, LowerCaseFilter::new)).putUnique(name, (Object)"standard", (Object)PreConfiguredTokenFilter.singletonWithVersion("standard", false, (reader, version) -> {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("standard_deprecation", "The [standard] token filter is deprecated and will be removed in a future version.", new Object[0]);
            return reader;
        }));
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenFilter filter : plugin.getPreConfiguredTokenFilters()) {
                preConfiguredTokenFilters.putUnique(name, (Object)filter.getName(), (Object)filter);
            }
        }
        return preConfiguredTokenFilters.immutableMap();
    }

    static Map<String, PreConfiguredTokenizer> setupPreConfiguredTokenizers(List<AnalysisPlugin> plugins) {
        String mapName = "pre-configured tokenizer";
        MapBuilder preConfiguredTokenizers = MapBuilder.newMapBuilder();
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltTokenizers.values()) {
            String name = preBuiltTokenizers.name().toLowerCase(Locale.ROOT);
            preConfiguredTokenizers.putUnique(mapName, (Object)name, (Object)(switch (preBuiltTokenizers.getCachingStrategy()) {
                case PreBuiltCacheFactory.CachingStrategy.ONE -> PreConfiguredTokenizer.singleton(name, () -> preBuiltTokenizers.create(Version.CURRENT), null);
                default -> throw new UnsupportedOperationException("Caching strategy unsupported by temporary shim [" + String.valueOf((Object)preBuiltTokenizers) + "]");
            }));
        }
        for (AnalysisPlugin plugin : plugins) {
            for (PreConfiguredTokenizer preConfiguredTokenizer : plugin.getPreConfiguredTokenizers()) {
                preConfiguredTokenizers.putUnique(mapName, (Object)preConfiguredTokenizer.getName(), (Object)preConfiguredTokenizer);
            }
        }
        return preConfiguredTokenizers.immutableMap();
    }

    static {
        IndexMetadata metadata = IndexMetadata.builder(UUIDs.randomBase64UUID()).indexName("_na_").settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).build()).build();
        NA_INDEX_SETTINGS = new IndexSettings(metadata, Settings.EMPTY);
        DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(AnalysisModule.class));
    }

    public static interface AnalysisProvider<T> {
        public T get(IndexSettings var1, Environment var2, String var3, Settings var4) throws IOException;

        default public T get(Environment environment, String name) throws IOException {
            if (this.requiresAnalysisSettings()) {
                throw new IllegalArgumentException("Analysis settings required - can't instantiate analysis factory");
            }
            return this.get(NA_INDEX_SETTINGS, environment, name, NA_INDEX_SETTINGS.getSettings());
        }

        default public boolean requiresAnalysisSettings() {
            return false;
        }
    }
}

