/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.blob.exceptions.IllegalBlobRecoveryStateException;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import io.crate.common.Hex;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.indices.recovery.BlobFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryChunkRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryDeleteRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryStartTransferRequest;
import org.elasticsearch.indices.recovery.BlobRecoveryStatus;
import org.elasticsearch.indices.recovery.BlobRecoveryTransferStatus;
import org.elasticsearch.indices.recovery.BlobStartPrefixResponse;
import org.elasticsearch.indices.recovery.BlobStartPrefixSyncRequest;
import org.elasticsearch.indices.recovery.BlobStartRecoveryRequest;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveriesCollection;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class BlobRecoveryTarget {
    private static final Logger LOGGER = LogManager.getLogger(BlobRecoveryTarget.class);
    private final ConcurrentMap<Long, BlobRecoveryStatus> onGoingBlobRecoveries = new ConcurrentHashMap<Long, BlobRecoveryStatus>();
    private final BlobIndicesService blobIndicesService;
    private final PeerRecoveryTargetService peerRecoveryTargetService;

    @Inject
    public BlobRecoveryTarget(BlobIndicesService blobIndicesService, PeerRecoveryTargetService peerRecoveryTargetService, TransportService transportService) {
        this.blobIndicesService = blobIndicesService;
        this.peerRecoveryTargetService = peerRecoveryTargetService;
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/start", "generic", BlobStartRecoveryRequest::new, new StartRecoveryRequestHandler());
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/start_prefix", "generic", BlobStartPrefixSyncRequest::new, new StartPrefixSyncRequestHandler());
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/transfer_chunk", "generic", BlobRecoveryChunkRequest::new, new TransferChunkRequestHandler());
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/start_transfer", "generic", BlobRecoveryStartTransferRequest::new, new StartTransferRequestHandler());
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/delete_file", "generic", BlobRecoveryDeleteRequest::new, new DeleteFileRequestHandler());
        transportService.registerRequestHandler("internal:crate:blob/shard/recovery/finalize_recovery", "generic", BlobFinalizeRecoveryRequest::new, new FinalizeRecoveryRequestHandler());
    }

    public static class Actions {
        public static final String FINALIZE_RECOVERY = "internal:crate:blob/shard/recovery/finalize_recovery";
        public static final String DELETE_FILE = "internal:crate:blob/shard/recovery/delete_file";
        public static final String START_RECOVERY = "internal:crate:blob/shard/recovery/start";
        public static final String START_PREFIX = "internal:crate:blob/shard/recovery/start_prefix";
        public static final String TRANSFER_CHUNK = "internal:crate:blob/shard/recovery/transfer_chunk";
        public static final String START_TRANSFER = "internal:crate:blob/shard/recovery/start_transfer";
    }

    class StartRecoveryRequestHandler
    implements TransportRequestHandler<BlobStartRecoveryRequest> {
        StartRecoveryRequestHandler() {
        }

        @Override
        public void messageReceived(BlobStartRecoveryRequest request, TransportChannel channel) throws Exception {
            LOGGER.info("[{}] StartRecoveryRequestHandler start recovery with recoveryId {}", (Object)request.shardId().id(), (Object)request.recoveryId);
            try (RecoveriesCollection.RecoveryRef statusSafe = BlobRecoveryTarget.this.peerRecoveryTargetService.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                RecoveryTarget onGoingIndexRecovery = statusSafe.target();
                if (onGoingIndexRecovery.cancellableThreads().isCancelled()) {
                    throw new IndexShardClosedException(request.shardId());
                }
                BlobShard blobShard = BlobRecoveryTarget.this.blobIndicesService.blobShardSafe(request.shardId());
                BlobRecoveryStatus status = new BlobRecoveryStatus(onGoingIndexRecovery, blobShard);
                BlobRecoveryTarget.this.onGoingBlobRecoveries.put(request.recoveryId(), status);
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        }
    }

    private class StartPrefixSyncRequestHandler
    implements TransportRequestHandler<BlobStartPrefixSyncRequest> {
        private StartPrefixSyncRequestHandler() {
        }

        @Override
        public void messageReceived(BlobStartPrefixSyncRequest request, TransportChannel channel) throws Exception {
            BlobRecoveryStatus status = (BlobRecoveryStatus)BlobRecoveryTarget.this.onGoingBlobRecoveries.get(request.recoveryId());
            if (status == null) {
                throw new IllegalBlobRecoveryStateException("could not retrieve BlobRecoveryStatus");
            }
            if (status.canceled()) {
                throw new IndexShardClosedException(status.shardId());
            }
            byte[][] currentDigests = status.blobShard.currentDigests(request.prefix());
            BlobStartPrefixResponse response = new BlobStartPrefixResponse(currentDigests);
            channel.sendResponse(response);
        }
    }

    private class TransferChunkRequestHandler
    implements TransportRequestHandler<BlobRecoveryChunkRequest> {
        private TransferChunkRequestHandler() {
        }

        @Override
        public void messageReceived(BlobRecoveryChunkRequest request, TransportChannel channel) throws Exception {
            BlobRecoveryStatus onGoingRecovery = (BlobRecoveryStatus)BlobRecoveryTarget.this.onGoingBlobRecoveries.get(request.recoveryId());
            if (onGoingRecovery == null) {
                throw new IllegalBlobRecoveryStateException("Could not retrieve onGoingRecoveryStatus");
            }
            BlobRecoveryTransferStatus transferStatus = (BlobRecoveryTransferStatus)onGoingRecovery.onGoingTransfers().get(request.transferId());
            BlobShard shard = onGoingRecovery.blobShard;
            if (onGoingRecovery.canceled()) {
                onGoingRecovery.sentCanceledToSource();
                throw new IndexShardClosedException(onGoingRecovery.shardId());
            }
            if (transferStatus == null) {
                throw new IndexShardClosedException(onGoingRecovery.shardId());
            }
            request.content().writeTo(transferStatus.outputStream());
            if (request.isLast()) {
                transferStatus.outputStream().close();
                Path baseDirectory = shard.blobContainer().getBaseDirectory();
                Path source = baseDirectory.resolve(transferStatus.sourcePath());
                Path target = baseDirectory.resolve(transferStatus.targetPath());
                Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                onGoingRecovery.onGoingTransfers().remove(request.transferId());
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class StartTransferRequestHandler
    implements TransportRequestHandler<BlobRecoveryStartTransferRequest> {
        private StartTransferRequestHandler() {
        }

        @Override
        public void messageReceived(BlobRecoveryStartTransferRequest request, TransportChannel channel) throws Exception {
            BlobRecoveryStatus status = (BlobRecoveryStatus)BlobRecoveryTarget.this.onGoingBlobRecoveries.get(request.recoveryId());
            LOGGER.debug("received BlobRecoveryStartTransferRequest for file {} with size {}", (Object)request.path(), (Object)request.size());
            if (status == null) {
                throw new IllegalBlobRecoveryStateException("Could not retrieve onGoingRecoveryStatus");
            }
            if (status.canceled()) {
                throw new IndexShardClosedException(status.shardId());
            }
            BlobShard shard = status.blobShard;
            String tmpPath = request.path() + "." + request.transferId();
            Path baseDirectory = shard.blobContainer().getBaseDirectory();
            FileOutputStream outputStream = new FileOutputStream(baseDirectory.resolve(tmpPath).toFile());
            request.content().writeTo(outputStream);
            if (request.size() == (long)request.content().length()) {
                outputStream.close();
                Path source = baseDirectory.resolve(tmpPath);
                Path target = baseDirectory.resolve(request.path());
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            } else {
                BlobRecoveryTransferStatus transferStatus = new BlobRecoveryTransferStatus(request.transferId(), outputStream, tmpPath, request.path());
                status.onGoingTransfers().put(request.transferId(), transferStatus);
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class DeleteFileRequestHandler
    implements TransportRequestHandler<BlobRecoveryDeleteRequest> {
        private DeleteFileRequestHandler() {
        }

        @Override
        public void messageReceived(BlobRecoveryDeleteRequest request, TransportChannel channel) throws Exception {
            BlobRecoveryStatus status = (BlobRecoveryStatus)BlobRecoveryTarget.this.onGoingBlobRecoveries.get(request.recoveryId());
            if (status.canceled()) {
                throw new IndexShardClosedException(status.shardId());
            }
            for (BytesReference digest : request.digests) {
                status.blobShard.delete(Hex.encodeHexString((byte[])BytesReference.toBytes(digest)));
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class FinalizeRecoveryRequestHandler
    implements TransportRequestHandler<BlobFinalizeRecoveryRequest> {
        private FinalizeRecoveryRequestHandler() {
        }

        @Override
        public void messageReceived(BlobFinalizeRecoveryRequest request, TransportChannel channel) throws Exception {
            BlobRecoveryStatus status = (BlobRecoveryStatus)BlobRecoveryTarget.this.onGoingBlobRecoveries.get(request.recoveryId);
            for (BlobRecoveryTransferStatus transferStatus : status.onGoingTransfers().values()) {
                if (!transferStatus.outputStream().getChannel().isOpen()) continue;
                throw new IllegalBlobRecoveryStateException("File channel was left open for ");
            }
            BlobRecoveryTarget.this.onGoingBlobRecoveries.remove(request.recoveryId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

