/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import io.crate.common.Suppliers;
import io.crate.common.unit.TimeValue;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;

public class OsService {
    private static final Logger LOGGER = LogManager.getLogger(OsService.class);
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final Supplier<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public OsService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), EsExecutors.numberOfProcessors(settings));
        this.osStatsCache = Suppliers.memoizeWithExpiration((TimeValue)refreshInterval, this.probe::osStats);
        LOGGER.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public OsInfo info() {
        return this.info;
    }

    public OsStats stats() {
        return this.osStatsCache.get();
    }
}

