/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import io.crate.common.Suppliers;
import io.crate.common.unit.TimeValue;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;

public final class ProcessService {
    private static final Logger LOGGER = LogManager.getLogger(ProcessService.class);
    private final ProcessProbe probe = ProcessProbe.getInstance();
    private final Supplier<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.process.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public ProcessService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = Suppliers.memoizeWithExpiration((TimeValue)refreshInterval, this.probe::processStats);
        LOGGER.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public ProcessStats stats() {
        return this.processStatsCache.get();
    }
}

