/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import io.crate.analyze.repositories.TypeSettings;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.jetbrains.annotations.Nullable;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public CompletableFuture<SnapshotInfo> getSnapshotInfo(SnapshotId var1);

    public CompletableFuture<Metadata> getSnapshotGlobalMetadata(SnapshotId var1);

    public CompletableFuture<Collection<IndexMetadata>> getSnapshotIndexMetadata(Metadata var1, RepositoryData var2, SnapshotId var3, Collection<IndexId> var4);

    public CompletableFuture<RepositoryData> getRepositoryData();

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version var6, UnaryOperator<ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version var4, ActionListener<RepositoryData> var5);

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(Store var1, SnapshotId var2, IndexId var3, IndexCommit var4, @Nullable String var5, IndexShardSnapshotStatus var6, Version var7, ActionListener<String> var8);

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    public CompletableFuture<IndexShardSnapshotStatus> getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }

        public TypeSettings settings();
    }
}

