/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import io.crate.common.collections.Tuple;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.concurrent.FutureActionListener;
import io.crate.concurrent.MultiActionListener;
import io.crate.exceptions.InvalidArgumentException;
import io.crate.server.xcontent.LoggingDeprecationHandler;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger LOGGER = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    private static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", true, Setting.Property.NodeScope);
    private static final Setting<ByteSizeValue> IO_BUFFER_SIZE_SETTING = Setting.byteSizeSetting("io_buffer_size", ByteSizeValue.parseBytesSizeValue("128kb", "io_buffer_size"), ByteSizeValue.parseBytesSizeValue("8kb", "buffer_size"), ByteSizeValue.parseBytesSizeValue("16mb", "io_buffer_size"), Setting.Property.NodeScope);
    private final boolean compress;
    private final RateLimiter snapshotRateLimiter;
    private final RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat<Metadata>("metadata", "meta-%s.dat", Metadata::fromXContent, Metadata::readFrom);
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat<IndexMetadata>("index-metadata", "meta-%s.dat", IndexMetadata::fromXContent, IndexMetadata::readFrom);
    private static final String SNAPSHOT_CODEC = "snapshot";
    public static final ChecksumBlobStoreFormat<SnapshotInfo> SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<SnapshotInfo>("snapshot", "snap-%s.dat", SnapshotInfo::fromXContentInternal, SnapshotInfo::new);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> INDEX_SHARD_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>("snapshot", "snap-%s.dat", BlobStoreIndexShardSnapshot::fromXContent, BlobStoreIndexShardSnapshot::new);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> INDEX_SHARD_SNAPSHOTS_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>("snapshots", "index-%s", BlobStoreIndexShardSnapshots::fromXContent, BlobStoreIndexShardSnapshots::fromStream);
    private final boolean readOnly;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final BlobPath basePath;
    private final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final NamedXContentRegistry namedXContentRegistry;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    protected final int bufferSize;
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);

    protected BlobStoreRepository(RepositoryMetadata metadata, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings, BlobPath basePath) {
        this.metadata = metadata;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.namedXContentRegistry = namedXContentRegistry;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.compress = COMPRESS_SETTING.get(metadata.settings());
        this.recoverySettings = recoverySettings;
        this.snapshotRateLimiter = this.getRateLimiter(metadata.settings(), "max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(metadata.settings(), "max_restore_bytes_per_sec", ByteSizeValue.ZERO);
        this.readOnly = metadata.settings().getAsBoolean("readonly", false);
        this.basePath = basePath;
        this.bufferSize = Math.toIntExact(IO_BUFFER_SIZE_SETTING.get(metadata.settings()).getBytes());
    }

    @Override
    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + String.valueOf(chunkSize) + "]");
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                LOGGER.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    @Override
    public void executeConsistentStateUpdate(final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, final Consumer<Exception> onFailure) {
        final RepositoryMetadata repositoryMetadataStart = this.metadata;
        this.getRepositoryData().whenComplete(ActionListener.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.clusterService.submitStateUpdateTask(source, new ClusterStateUpdateTask(this, updateTask.priority()){
                private boolean executedTask;
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                    super(priority);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (repositoryMetadataStart.equals(this.this$0.getRepoMetadata(currentState))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(source, e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(source, oldState, newState);
                    } else {
                        this.this$0.executeConsistentStateUpdate(createUpdateTask, source, onFailure);
                    }
                }

                @Override
                public TimeValue timeout() {
                    return updateTask.timeout();
                }
            });
        }, onFailure));
    }

    @Override
    public void updateState(ClusterState state) {
        this.metadata = this.getRepoMetadata(state);
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean wasBestEffortConsistency = this.bestEffortConsistency;
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || state.nodes().getMinNodeVersion().before(RepositoryMetadata.REPO_GEN_IN_CS_VERSION) || this.metadata.generation() == -2L;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
            long bestGenerationFromCS = this.bestGeneration(snapshotsInProgress.entries());
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, finalBestGen));
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (wasBestEffortConsistency || this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                LOGGER.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    protected BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        this.assertSnapshotOrGenericThread();
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (InvalidArgumentException | RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store: " + e.getMessage(), e);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public BlobPath basePath() {
        return this.basePath;
    }

    protected final boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void deleteSnapshots(final Collection<SnapshotId> snapshotIds, final long repositoryStateId, final Version repositoryMetaVersion, final ActionListener<RepositoryData> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            this.threadPool.executor(SNAPSHOT_CODEC).execute(new RejectableRunnable(){
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void doRun() throws Exception {
                    Map<String, BlobMetadata> rootBlobs = this.this$0.blobContainer().listBlobs();
                    RepositoryData repositoryData = this.this$0.safeRepositoryData(repositoryStateId, rootBlobs);
                    Map<String, BlobContainer> foundIndices = this.this$0.blobStore().blobContainer(this.this$0.indicesPath()).children();
                    this.this$0.doDeleteShardSnapshots(snapshotIds, repositoryStateId, foundIndices, rootBlobs, repositoryData, repositoryMetaVersion, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "failed to delete snapshots " + String.valueOf(snapshotIds), e));
                }
            });
        }
    }

    private RepositoryData safeRepositoryData(long repositoryStateId, Map<String, BlobMetadata> rootBlobs) {
        long generation;
        long genToLoad = this.bestEffortConsistency ? this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, repositoryStateId)) : this.latestKnownRepoGen.get();
        if (genToLoad > (generation = this.latestGeneration(rootBlobs.keySet()))) {
            LOGGER.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + genToLoad + "]");
        }
        return this.getRepositoryData(genToLoad);
    }

    private void doDeleteShardSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData repositoryData, Version repoMetaVersion, ActionListener<RepositoryData> listener) {
        if (SnapshotsService.useShardGenerations(repoMetaVersion)) {
            StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeShardMetaDataAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
            this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, true, writeShardMetaDataAndComputeDeletesStep);
            StepListener<RepositoryData> writeUpdatedRepoDataStep = new StepListener<RepositoryData>();
            writeShardMetaDataAndComputeDeletesStep.whenComplete(deleteResults -> {
                ShardGenerations.Builder builder = ShardGenerations.builder();
                for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                    builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
                }
                RepositoryData updatedRepoData = repositoryData.removeSnapshots(snapshotIds, builder.build());
                this.writeIndexGen(updatedRepoData, repositoryStateId, repoMetaVersion, UnaryOperator.identity(), ActionListener.wrap(writeUpdatedRepoDataStep::onResponse, listener::onFailure));
            }, listener::onFailure);
            writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
                ActionListener<Void> afterCleanupsListener = MultiActionListener.of(2, ActionListener.wrap(() -> listener.onResponse((RepositoryData)updatedRepoData)));
                this.asyncCleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)updatedRepoData, afterCleanupsListener);
                this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), afterCleanupsListener);
            }, listener::onFailure);
        } else {
            RepositoryData updatedRepoData2 = repositoryData.removeSnapshots(snapshotIds, ShardGenerations.EMPTY);
            this.writeIndexGen(updatedRepoData2, repositoryStateId, repoMetaVersion, UnaryOperator.identity(), ActionListener.wrap(newRepoData -> {
                ActionListener<Void> afterCleanupsListener = MultiActionListener.of(2, ActionListener.wrap(() -> listener.onResponse((RepositoryData)newRepoData)));
                this.asyncCleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)newRepoData, afterCleanupsListener);
                StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeMetaAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
                this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, false, writeMetaAndComputeDeletesStep);
                writeMetaAndComputeDeletesStep.whenComplete(deleteResults -> this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection<ShardSnapshotMetaDeleteResult>)deleteResults, afterCleanupsListener), afterCleanupsListener::onFailure);
            }, listener::onFailure));
        }
    }

    private void asyncCleanupUnlinkedRootAndIndicesBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData updatedRepoData, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> this.cleanupStaleBlobs(deletedSnapshots, foundIndices, rootBlobs, updatedRepoData, l.map(ignored -> null))));
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            try {
                this.deleteFromContainer(this.blobContainer(), this.resolveFilesToDelete(oldRepositoryData, snapshotIds, deleteResults));
                l.onResponse(null);
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("{} Failed to delete some blobs during snapshot delete", (Object)snapshotIds), (Throwable)e);
                throw e;
            }
        }));
    }

    private void writeUpdatedShardMetaDataAndComputeDeletes(final Collection<SnapshotId> snapshotIds, final RepositoryData oldRepositoryData, final boolean useUUIDs, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        ActionListener deleteIndexMetadataListener = MultiActionListener.of(indices.size(), onAllShardsCompleted.map(res -> res.stream().flatMap(Collection::stream).toList()));
        for (final IndexId indexId : indices) {
            final Set survivingSnapshots = oldRepositoryData.getSnapshots(indexId).stream().filter(id -> !snapshotIds.contains(id)).collect(Collectors.toSet());
            StepListener shardCountListener = new StepListener();
            Collection indexMetaGenerations = snapshotIds.stream().map(id -> oldRepositoryData.indexMetaDataGenerations().indexMetaBlobId((SnapshotId)id, indexId)).collect(Collectors.toSet());
            ActionListener allShardCountsListener = MultiActionListener.of(indexMetaGenerations.size(), shardCountListener);
            BlobContainer indexContainer = this.indexContainer(indexId);
            for (String indexMetaGeneration : indexMetaGenerations) {
                executor.execute(ActionRunnable.supply(allShardCountsListener, () -> {
                    try {
                        return INDEX_METADATA_FORMAT.read(indexContainer, indexMetaGeneration, this.namedWriteableRegistry, this.namedXContentRegistry).getNumberOfShards();
                    }
                    catch (Exception ex) {
                        LOGGER.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)indexMetaGeneration, (Object)indexId.getName()), (Throwable)ex);
                        return null;
                    }
                }));
            }
            shardCountListener.whenComplete(counts -> {
                int shardCount = counts.stream().mapToInt(i -> i).max().orElse(0);
                if (shardCount == 0) {
                    deleteIndexMetadataListener.onResponse(null);
                    return;
                }
                final ActionListener allShardsListener = MultiActionListener.of(shardCount, deleteIndexMetadataListener);
                int shardId = 0;
                while (shardId < shardCount) {
                    final int finalShardId = shardId++;
                    executor.execute(new RejectableRunnable(){
                        final /* synthetic */ BlobStoreRepository this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            long newGen;
                            BlobContainer shardContainer = this.this$0.shardContainer(indexId, finalShardId);
                            Set<String> blobs = shardContainer.listBlobs().keySet();
                            if (useUUIDs) {
                                newGen = -1L;
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)this.this$0.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, finalShardId)).v1();
                            } else {
                                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.this$0.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                newGen = (Long)tuple.v2() + 1L;
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
                            }
                            allShardsListener.onResponse(this.this$0.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, finalShardId, snapshotIds, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen));
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            LOGGER.warn(() -> new ParameterizedMessage("{} failed to delete shard data for shard [{}][{}]", new Object[]{snapshotIds, indexId.getName(), finalShardId}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }, deleteIndexMetadataListener::onFailure);
        }
    }

    private List<String> resolveFilesToDelete(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        String basePath = this.basePath().buildAsString();
        int basePathLen = basePath.length();
        Map<IndexId, Collection<String>> indexMetaGenerations = oldRepositoryData.indexMetaDataToRemoveAfterRemovingSnapshots(snapshotIds);
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            String shardPath = this.shardContainer(shardResult.indexId, shardResult.shardId).path().buildAsString();
            return shardResult.blobsToDelete.stream().map(blob -> shardPath + blob);
        }), indexMetaGenerations.entrySet().stream().flatMap(entry -> {
            String indexContainerPath = this.indexContainer((IndexId)entry.getKey()).path().buildAsString();
            return ((Collection)entry.getValue()).stream().map(id -> indexContainerPath + INDEX_METADATA_FORMAT.blobName((String)id));
        })).map(absolutePath -> {
            assert (absolutePath.startsWith(basePath));
            return absolutePath.substring(basePathLen);
        }).collect(Collectors.toList());
    }

    private void cleanupStaleBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData newRepoData, ActionListener<Long> listener) {
        MultiActionListener groupedListener = new MultiActionListener(2, Collectors.summingLong(Long::longValue), listener);
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(groupedListener, () -> {
            List<String> deletedBlobs = this.cleanupStaleRootFiles(deletedSnapshots, this.staleRootBlobs(newRepoData, rootBlobs.keySet()));
            return deletedBlobs.size();
        }));
        Set<String> survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        this.cleanupStaleIndices(foundIndices, survivingIndexIds, groupedListener);
    }

    private List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (SNAPSHOT_FORMAT.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (GLOBAL_METADATA_FORMAT.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            if (blob.startsWith("index-")) {
                return repositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(Collection<SnapshotId> deletedSnapshots, List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                Set blobNamesToIgnore = deletedSnapshots.stream().flatMap(snapshotId -> Stream.of(GLOBAL_METADATA_FORMAT.blobName(snapshotId.getUUID()), SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))).collect(Collectors.toSet());
                List blobsToLog = blobsToDelete.stream().filter(b -> !blobNamesToIgnore.contains(b)).collect(Collectors.toList());
                if (!blobsToLog.isEmpty()) {
                    LOGGER.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToLog);
                }
            }
            this.deleteFromContainer(this.blobContainer(), blobsToDelete);
            return blobsToDelete;
        }
        catch (IOException e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
        }
        catch (Exception e) {
            assert (false) : e;
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of root level blobs", (Object)this.metadata.name()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void cleanupStaleIndices(Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds, ActionListener<Long> listener) {
        try {
            LinkedBlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete = new LinkedBlockingQueue<Map.Entry<String, BlobContainer>>();
            for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
                if (survivingIndexIds.contains(indexEntry.getKey())) continue;
                staleIndicesToDelete.put(indexEntry);
            }
            MultiActionListener groupedListener = new MultiActionListener(staleIndicesToDelete.size(), Collectors.summingLong(Long::longValue), listener);
            Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int maximumPoolSize = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : 1;
            int workers = Math.min(maximumPoolSize, staleIndicesToDelete.size());
            for (int i = 0; i < workers; ++i) {
                this.executeOneStaleIndexDelete(staleIndicesToDelete, groupedListener);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale indices", (Object)this.metadata.name()), (Throwable)e);
        }
    }

    private void executeOneStaleIndexDelete(BlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete, ActionListener<Long> listener) throws InterruptedException {
        Map.Entry<String, BlobContainer> indexEntry = staleIndicesToDelete.poll(0L, TimeUnit.MILLISECONDS);
        if (indexEntry != null) {
            String indexSnId = indexEntry.getKey();
            this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.supply(listener, () -> {
                try {
                    ((BlobContainer)indexEntry.getValue()).delete();
                    LOGGER.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
                    this.executeOneStaleIndexDelete(staleIndicesToDelete, listener);
                    return 1L;
                }
                catch (IOException e) {
                    LOGGER.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshots in the repository, but failed to clean up their index folders", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
                    return 0L;
                }
                catch (Exception e) {
                    assert (false) : e;
                    LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception during single stale index delete", (Object)this.metadata.name()), (Throwable)e);
                    return 0L;
                }
            }));
        }
    }

    @Override
    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, UnaryOperator<ClusterState> stateTransformer, ActionListener<RepositoryData> listener) {
        assert (repositoryStateId > -2L) : "Must finalize based on a valid repository generation but received [" + repositoryStateId + "]";
        Collection<IndexId> indices = shardGenerations.indices();
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        boolean writeShardGens = SnapshotsService.useShardGenerations(repositoryMetaVersion);
        Consumer<Exception> onUpdateFailure = e -> listener.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e));
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        boolean writeIndexGens = SnapshotsService.useIndexGenerations(repositoryMetaVersion);
        ((CompletableFuture)this.getRepositoryData().whenComplete((existingRepositoryData, err) -> {
            ConcurrentHashMap indexMetas;
            ConcurrentHashMap indexMetaIdentifiers;
            if (err != null) {
                onUpdateFailure.accept(Exceptions.toException((Throwable)err));
                return;
            }
            if (writeIndexGens) {
                indexMetaIdentifiers = new ConcurrentHashMap();
                indexMetas = new ConcurrentHashMap();
            } else {
                indexMetas = null;
                indexMetaIdentifiers = null;
            }
            ActionListener onAllIndicesFinishedListener = ActionListener.wrap(v -> {
                RepositoryData updatedRepositoryData = existingRepositoryData.addSnapshot(snapshotId, snapshotInfo.state(), Version.CURRENT, shardGenerations, indexMetas, indexMetaIdentifiers);
                this.writeIndexGen(updatedRepositoryData, repositoryStateId, repositoryMetaVersion, stateTransformer, ActionListener.wrap(newRepoData -> {
                    if (writeShardGens) {
                        this.cleanupOldShardGens((RepositoryData)existingRepositoryData, updatedRepositoryData);
                    }
                    listener.onResponse((RepositoryData)newRepoData);
                }, onUpdateFailure));
            }, onUpdateFailure);
            ActionListener allMetaListener = MultiActionListener.of(2 + indices.size(), onAllIndicesFinishedListener);
            executor.execute(ActionRunnable.run(allMetaListener, () -> GLOBAL_METADATA_FORMAT.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), this.compress)));
            for (IndexId index : indices) {
                executor.execute(ActionRunnable.run(allMetaListener, () -> {
                    IndexMetadata indexMetaData = clusterMetadata.getIndexByName(index.getName());
                    if (writeIndexGens) {
                        String identifiers = IndexMetaDataGenerations.buildUniqueIdentifier(indexMetaData);
                        IndexMetaDataGenerations existingIndexMetaGenerations = existingRepositoryData.indexMetaDataGenerations();
                        String metaUUID = existingIndexMetaGenerations.getIndexMetaBlobId(identifiers);
                        if (metaUUID == null) {
                            metaUUID = UUIDs.base64UUID();
                            INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), metaUUID, this.compress);
                            indexMetaIdentifiers.put(identifiers, metaUUID);
                        }
                        indexMetas.put(index, identifiers);
                    } else {
                        INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), snapshotId.getUUID(), this.compress);
                    }
                }));
            }
            executor.execute(ActionRunnable.run(allMetaListener, () -> SNAPSHOT_FORMAT.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), this.compress)));
        })).exceptionally(err -> {
            listener.onFailure(Exceptions.toException((Throwable)err));
            return null;
        });
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData) {
        ArrayList<String> toDelete = new ArrayList<String>();
        int prefixPathLen = this.basePath().buildAsString().length();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardContainer((IndexId)indexId, (int)shardId).path().buildAsString().substring(prefixPathLen) + "index-" + oldGen)));
        try {
            this.deleteFromContainer(this.blobContainer(), toDelete);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clean up old shard generation blobs", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<SnapshotInfo> getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return CompletableFuture.completedFuture(SNAPSHOT_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedWriteableRegistry, this.namedXContentRegistry));
        }
        catch (NoSuchFileException ex) {
            return CompletableFuture.failedFuture(new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex));
        }
        catch (IOException | NotXContentException ex) {
            return CompletableFuture.failedFuture(new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Metadata> getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return CompletableFuture.completedFuture(GLOBAL_METADATA_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedWriteableRegistry, this.namedXContentRegistry));
        }
        catch (NoSuchFileException ex) {
            return CompletableFuture.failedFuture(new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex));
        }
        catch (IOException ex) {
            return CompletableFuture.failedFuture(new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex));
        }
    }

    @Override
    public CompletableFuture<Collection<IndexMetadata>> getSnapshotIndexMetadata(Metadata snapshotMetadata, RepositoryData repositoryData, SnapshotId snapshotId, Collection<IndexId> indexIds) {
        try {
            ArrayList<IndexMetadata> result = new ArrayList<IndexMetadata>(indexIds.size());
            for (IndexId index : indexIds) {
                result.add(INDEX_METADATA_FORMAT.read(this.indexContainer(index), repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, index), this.namedWriteableRegistry, this.namedXContentRegistry));
            }
            return CompletableFuture.completedFuture(result);
        }
        catch (IOException ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private void deleteFromContainer(BlobContainer container, List<String> blobs) throws IOException {
        LOGGER.trace(() -> new ParameterizedMessage("[{}] Deleting {} from [{}]", new Object[]{this.metadata.name(), blobs, container.path()}));
        container.deleteBlobsIgnoringIfNotExists(blobs);
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId.id())));
    }

    public BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId)));
    }

    private RateLimiter getRateLimiter(Settings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.getAsBytesSize(setting, defaultRate);
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains("[snapshot]") || Thread.currentThread().getName().contains("[search]") || Thread.currentThread().getName().contains("generic")) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = seed.getBytes(StandardCharsets.UTF_8);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            BytesArray bytes = new BytesArray(testBytes);
            try (StreamInput stream = bytes.streamInput();){
                testContainer.writeBlobAtomic("master.dat", stream, bytes.length(), true);
            }
            return seed;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Throwable errorInfo = cause == null ? e : cause;
            throw new RepositoryVerificationException(this.metadata.name(), String.format(Locale.ENGLISH, "Unable to verify the repository, [%s] is not accessible on master node: %s '%s'", this.metadata.name(), errorInfo.getClass().getSimpleName(), errorInfo.getMessage()), errorInfo);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                String testPrefix = BlobStoreRepository.testBlobPrefix(seed);
                this.blobStore().blobContainer(this.basePath().add(testPrefix)).delete();
            }
            catch (IOException exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + String.valueOf(this.basePath()), exp);
            }
        }
    }

    @Override
    public CompletableFuture<RepositoryData> getRepositoryData() {
        if (this.latestKnownRepoGen.get() == -3L) {
            return CompletableFuture.failedFuture(this.corruptedStateException(null));
        }
        FutureActionListener<RepositoryData> listener = new FutureActionListener<RepositoryData>();
        this.threadPool.generic().execute(ActionRunnable.run(listener, () -> this.doGetRepositoryData(listener)));
        return listener;
    }

    private void doGetRepositoryData(ActionListener<RepositoryData> listener) {
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (IOException ioe) {
                    listener.onFailure(new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", ioe));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, generation));
                if (genToLoad > generation) {
                    LOGGER.info("Determined repository generation [" + generation + "] from repository contents but correct generation must be at least [" + genToLoad + "]");
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                listener.onResponse(this.getRepositoryData(genToLoad));
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    LOGGER.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && Exceptions.firstCause((Throwable)e, (Class[])new Class[]{NoSuchFileException.class}) != null) {
                    this.markRepoCorrupted(genToLoad, e, ActionListener.wrap(v -> listener.onFailure(this.corruptedStateException(e)), listener::onFailure));
                } else {
                    listener.onFailure(e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e));
                return;
            }
            break;
        }
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause) {
        return new RepositoryException(this.metadata.name(), "Could not read repository data because the contents of the repository do not match its expected state. This is likely the result of either concurrently modifying the contents of the repository by a process other than this cluster or an issue with the repository's underlying storage. The repository has been disabled to prevent corrupting its contents. To re-enable it and continue using it please remove the repository from the cluster and add it again to make the cluster recover the known state of the repository from its physical contents.", cause);
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        this.clusterService.submitStateUpdateTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(this){
            final /* synthetic */ BlobStoreRepository this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetadata state = (RepositoriesMetadata)currentState.metadata().custom("repositories");
                RepositoryMetadata repoState = state.repository(this.this$0.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + String.valueOf(repoState) + "]");
                }
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", state.withUpdatedGeneration(this.this$0.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed marking repository state as corrupted", Exceptions.useOrSuppress((Throwable)e, (Throwable)originalException)));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + Long.toString(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen, false);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                LOGGER.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    public static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void writeIndexGen(final RepositoryData repositoryData, final long expectedGen, Version version, final UnaryOperator<ClusterState> stateFilter, final ActionListener<RepositoryData> listener) {
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]"));
            return;
        }
        final StepListener<Long> setPendingStep = new StepListener<Long>();
        this.clusterService.submitStateUpdateTask("set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]", new ClusterStateUpdateTask(this){
            private long newGen;
            final /* synthetic */ BlobStoreRepository this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetadata meta = this.this$0.getRepoMetadata(currentState);
                String repoName = this.this$0.metadata.name();
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || this.this$0.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    LOGGER.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + String.valueOf(meta) + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = this.this$0.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > this.this$0.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + this.this$0.latestKnownRepoGen.get() + "]";
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                setPendingStep.onResponse(this.newGen);
            }
        });
        final StepListener<RepositoryData> filterRepositoryDataStep = new StepListener<RepositoryData>();
        setPendingStep.whenComplete(newGen -> this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            final List snapshotIdsWithoutVersion = repositoryData.getSnapshotIds().stream().filter(snapshotId -> repositoryData.getVersion((SnapshotId)snapshotId) == null).collect(Collectors.toList());
            if (!snapshotIdsWithoutVersion.isEmpty()) {
                final ConcurrentHashMap updatedVersionMap = new ConcurrentHashMap();
                ActionListener<Void> loadAllVersionsListener = MultiActionListener.of(snapshotIdsWithoutVersion.size(), new ActionListener<Collection<Void>>(){

                    @Override
                    public void onResponse(Collection<Void> voids) {
                        LOGGER.info("Successfully loaded all snapshot's version information for {} from snapshot metadata", (Object)AllocationService.firstListElementsToCommaDelimitedString(snapshotIdsWithoutVersion, SnapshotId::toString, LOGGER.isDebugEnabled()));
                        filterRepositoryDataStep.onResponse(repositoryData.withVersions(updatedVersionMap));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        LOGGER.warn("Failure when trying to load missing version information from snapshot metadata", (Throwable)e);
                        filterRepositoryDataStep.onResponse(repositoryData.withVersions(updatedVersionMap));
                    }
                });
                for (SnapshotId snapshotId2 : snapshotIdsWithoutVersion) {
                    this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.run(loadAllVersionsListener, () -> this.getSnapshotInfo(snapshotId2).whenComplete((snapshotInfo, err) -> {
                        if (err == null) {
                            updatedVersionMap.put(snapshotId2, snapshotInfo.version());
                            loadAllVersionsListener.onResponse(null);
                        } else {
                            loadAllVersionsListener.onFailure(Exceptions.toException((Throwable)err));
                        }
                    })));
                }
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        })), listener::onFailure);
        filterRepositoryDataStep.whenComplete(filteredRepositoryData -> {
            final long newGen = (Long)setPendingStep.result();
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            if (!this.ensureSafeGenerationExists(expectedGen, listener::onFailure)) {
                return;
            }
            String indexBlob = "index-" + Long.toString(newGen);
            LOGGER.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            this.writeAtomic(this.blobContainer(), indexBlob, BytesReference.bytes(filteredRepositoryData.snapshotsToXContent(JsonXContent.builder(), version)), true);
            try {
                this.writeAtomic(this.blobContainer(), INDEX_LATEST_BLOB, new BytesArray(Numbers.longToBytes(newGen)), false);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to write index.latest blob. Repository cannot be used as a URL repository", (Throwable)e);
            }
            this.clusterService.submitStateUpdateTask("set safe repository generation [" + this.metadata.name() + "][" + newGen + "]", new ClusterStateUpdateTask(this, (RepositoryData)filteredRepositoryData){
                final /* synthetic */ RepositoryData val$filteredRepositoryData;
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.val$filteredRepositoryData = repositoryData;
                    this.this$0 = this$0;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetadata meta = this.this$0.getRepoMetadata(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + String.valueOf(meta) + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    return this.this$0.updateRepositoryGenerationsIfNecessary((ClusterState)stateFilter.apply(ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(this.this$0.metadata.name(), newGen, newGen))).build()), expectedGen, newGen);
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    RepositoryData writtenRepositoryData = this.val$filteredRepositoryData.withGenId(newGen);
                    this.this$0.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC).execute(ActionRunnable.supply(listener, () -> {
                        List<String> oldIndexN = LongStream.range(Math.max(Math.max(expectedGen - 1L, 0L), newGen - 1000L), newGen).mapToObj(gen -> "index-" + gen).collect(Collectors.toList());
                        try {
                            this.this$0.deleteFromContainer(this.this$0.blobContainer(), oldIndexN);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to clean up old index blobs {}", oldIndexN);
                        }
                        return writtenRepositoryData;
                    }));
                }
            });
        }, listener::onFailure);
    }

    private boolean ensureSafeGenerationExists(long safeGeneration, final Consumer<Exception> onFailure) throws IOException {
        LOGGER.debug("Ensure generation [{}] that is the basis for this write exists in [{}]", (Object)safeGeneration, (Object)this.metadata.name());
        if (safeGeneration != -1L && !this.blobContainer().blobExists("index-" + safeGeneration)) {
            final RepositoryException exception = new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + safeGeneration + "] but it was not found in the repository");
            this.markRepoCorrupted(safeGeneration, exception, new ActionListener<Void>(){

                @Override
                public void onResponse(Void aVoid) {
                    onFailure.accept(exception);
                }

                @Override
                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }
            });
            return false;
        }
        return true;
    }

    private ClusterState updateRepositoryGenerationsIfNecessary(ClusterState state, long oldGen, long newGen) {
        String repoName = this.metadata.name();
        boolean changedSnapshots = false;
        ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : state.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                snapshotEntries.add(entry.withRepoGen(newGen));
                changedSnapshots = true;
                continue;
            }
            snapshotEntries.add(entry);
        }
        SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? SnapshotsInProgress.of(snapshotEntries) : null;
        boolean changedDeletions = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> deletionEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                deletionEntries.add(entry.withRepoGen(newGen));
                changedDeletions = true;
                continue;
            }
            deletionEntries.add(entry);
        }
        SnapshotDeletionsInProgress updatedDeletionsInProgress = changedDeletions ? SnapshotDeletionsInProgress.of(deletionEntries) : null;
        return SnapshotsService.updateWithSnapshots(state, updatedSnapshotsInProgress, updatedDeletionsInProgress);
    }

    private RepositoryMetadata getRepoMetadata(ClusterState state) {
        RepositoryMetadata result = ((RepositoriesMetadata)state.metadata().custom("repositories")).repository(this.metadata.name());
        assert (result != null);
        return result;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        try (InputStream blob = this.blobContainer().readBlob(INDEX_LATEST_BLOB);){
            long l = Numbers.bytesToLong(Streams.readFully(blob).toBytesRef());
            return l;
        }
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(BlobContainer container, String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            LOGGER.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to {} atomically", new Object[]{this.metadata.name(), blobName, container.path()}));
            container.writeBlobAtomic(blobName, stream, bytesRef.length(), failIfAlreadyExists);
        }
    }

    @Override
    public void snapshotShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, ActionListener<String> listener) {
        ShardId shardId = store.shardId();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            Runnable afterWriteSnapBlob;
            String indexGeneration;
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles;
            Set<Object> blobs;
            String generation = ShardGenerations.fixShardGeneration(snapshotStatus.generation());
            LOGGER.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, String> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            String fileListGeneration = (String)tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            List filesFromSegmentInfos = Optional.ofNullable(shardStateIdentifier).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            if (filesFromSegmentInfos == null) {
                Collection fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList();
                try (Object ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    try {
                        LOGGER.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                    }
                }
                ignored = fileNames.iterator();
                while (ignored.hasNext()) {
                    String fileName = (String)ignored.next();
                    if (snapshotStatus.isAborted()) {
                        LOGGER.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                        throw new AbortedSnapshotException();
                    }
                    LOGGER.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetadata md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            if (!fileInfo.isSame(md)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                        }
                        assert (needsWrite || BlobStoreRepository.assertFileContentsMatchHash(snapshotFileInfo, store));
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesFromSegmentInfos) {
                    ++indexTotalNumberOfFiles;
                    indexTotalFileSize += fileInfo.length();
                }
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            boolean writeShardGens = SnapshotsService.useShardGenerations(repositoryMetaVersion);
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            newSnapshotsList.add(new SnapshotFiles(snapshotId.getName(), indexCommitPointFiles, shardStateIdentifier));
            for (SnapshotFiles point : snapshots) {
                newSnapshotsList.add(point);
            }
            BlobStoreIndexShardSnapshots updatedBlobStoreIndexShardSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            if (writeShardGens) {
                indexGeneration = UUIDs.randomBase64UUID();
                try {
                    INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedBlobStoreIndexShardSnapshots, shardContainer, indexGeneration, this.compress);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write shard level snapshot metadata for [" + String.valueOf(snapshotId) + "] to [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration) + "]", e);
                }
                afterWriteSnapBlob = () -> {};
            } else {
                long newGen = Long.parseLong(fileListGeneration) + 1L;
                indexGeneration = Long.toString(newGen);
                List blobsToDelete = blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toList());
                assert (blobsToDelete.stream().mapToLong(b -> Long.parseLong(b.replaceFirst("index-", ""))).max().orElse(-1L) < Long.parseLong(indexGeneration)) : "Tried to delete an index-N blob newer than the current generation [" + indexGeneration + "] when deleting index-N blobs " + String.valueOf(blobsToDelete);
                afterWriteSnapBlob = () -> {
                    try {
                        this.writeShardIndexBlobAtomic(shardContainer, newGen, updatedBlobStoreIndexShardSnapshots);
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to finalize snapshot creation [" + String.valueOf(snapshotId) + "] with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration) + "]", e);
                    }
                    try {
                        this.deleteFromContainer(shardContainer, blobsToDelete);
                    }
                    catch (IOException e) {
                        LOGGER.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete old index-N blobs during finalization", (Object)snapshotId, (Object)shardId), (Throwable)e);
                    }
                };
            }
            StepListener<Collection<Void>> allFilesUploadedListener = new StepListener<Collection<Void>>();
            allFilesUploadedListener.whenComplete(v -> {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                LOGGER.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                try {
                    INDEX_SHARD_SNAPSHOT_FORMAT.write(new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize()), shardContainer, snapshotId.getUUID(), this.compress);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                afterWriteSnapBlob.run();
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), indexGeneration);
                listener.onResponse(indexGeneration);
            }, listener::onFailure);
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int maximumPoolSize = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : 1;
            int workers = Math.min(maximumPoolSize, indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, filesListener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void executeOneFileSnapshot(Store store, SnapshotId snapshotId, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot, Executor executor, ActionListener<Void> listener) throws InterruptedException {
        ShardId shardId = store.shardId();
        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
        if (snapshotFileInfo == null) {
            listener.onResponse(null);
        } else {
            executor.execute(ActionRunnable.wrap(listener, l -> {
                try (Releasable ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                    this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, (ActionListener<Void>)l);
                }
            }));
        }
    }

    private static Releasable incrementStoreRef(Store store, IndexShardSnapshotStatus snapshotStatus, ShardId shardId) {
        if (!store.tryIncRef()) {
            if (snapshotStatus.isAborted()) {
                throw new AbortedSnapshotException();
            }
            assert (false) : "Store should not be closed concurrently unless snapshot is aborted";
            throw new IndexShardSnapshotFailedException(shardId, "Store got closed concurrently");
        }
        return store::decRef;
    }

    private static boolean assertFileContentsMatchHash(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
            byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
            indexInput.readBytes(tmp, 0, tmp.length);
            assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = listener.withOnFailure((l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + String.valueOf(snapshotId) + "]", (Throwable)e)));
        final Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        executor.execute(ActionRunnable.wrap(restoreListener, l -> {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(container, snapshotId);
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this, this.metadata.name(), shardId, snapshotId, recoveryState){
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                    super(repositoryName, shardId, snapshotId, recoveryState);
                }

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store2, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int maxPoolSize = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : 1;
                        int workers = Math.min(maxPoolSize, snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, listener.map(v -> null));
                        for (int i = 0; i < workers; ++i) {
                            try {
                                this.executeOneFileRestore(files, allFilesListener);
                                continue;
                            }
                            catch (Exception e) {
                                allFilesListener.onFailure(e);
                            }
                        }
                    }
                }

                private void executeOneFileRestore(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, ActionListener<Void> allFilesListener) throws InterruptedException {
                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover = files.poll(0L, TimeUnit.MILLISECONDS);
                    if (fileToRecover == null) {
                        allFilesListener.onResponse(null);
                    } else {
                        executor.execute(ActionRunnable.wrap(allFilesListener, filesListener -> {
                            store.incRef();
                            try {
                                this.restoreFile(fileToRecover, store);
                            }
                            finally {
                                store.decRef();
                            }
                            this.executeOneFileRestore(files, (ActionListener<Void>)filesListener);
                        }));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, final Store store2) throws IOException {
                    this.ensureNotClosing(store2);
                    LOGGER.trace(() -> new ParameterizedMessage("[{}] restoring [{}] to [{}]", new Object[]{this.this$0.metadata.name(), fileInfo, store2}));
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store2.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = this.this$0.maybeRateLimitRestores(new SlicedInputStream(this, fileInfo.numberOfParts()){
                                    final /* synthetic */ 9 this$1;
                                    {
                                        this.this$1 = this$1;
                                        super(numSlices);
                                    }

                                    @Override
                                    protected InputStream openSlice(int slice) throws IOException {
                                        this.this$1.ensureNotClosing(store2);
                                        return container.readBlob(fileInfo.partName(slice));
                                    }
                                });){
                                    int length;
                                    byte[] buffer = new byte[Math.toIntExact(Math.min((long)this.this$0.bufferSize, fileInfo.length()))];
                                    while ((length = stream.read(buffer)) > 0) {
                                        this.ensureNotClosing(store2);
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store2.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store2.markStoreCorrupted((IOException)ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                LOGGER.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store2.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store2.deleteQuiet(fileInfo.physicalName());
                    return;
                }

                void ensureNotClosing(Store store2) throws AlreadyClosedException {
                    assert (store2.refCount() > 0);
                    if (store2.isClosing()) {
                        throw new AlreadyClosedException("store is closing");
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return MultiActionListener.of(workers, listener).withOnFailure((l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static InputStream maybeRateLimit(InputStream stream, Supplier<RateLimiter> rateLimiterSupplier, CounterMetric metric) {
        return new RateLimitingInputStream(stream, rateLimiterSupplier, metric::inc);
    }

    public InputStream maybeRateLimitRestores(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(stream, () -> this.restoreRateLimiter, this.restoreRateLimitingTimeInNanos), this.recoverySettings::rateLimiter, this.restoreRateLimitingTimeInNanos);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(stream, () -> this.snapshotRateLimiter, this.snapshotRateLimitingTimeInNanos);
    }

    @Override
    public CompletableFuture<IndexShardSnapshotStatus> getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        try {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
            return CompletableFuture.completedFuture(IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize(), null));
        }
        catch (SnapshotException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        this.assertSnapshotOrGenericThread();
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + String.valueOf(this.basePath()) + " is not accessible on node " + String.valueOf(localNode), e);
            }
        }
        BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        try {
            BytesArray bytes = new BytesArray(seed);
            try (StreamInput stream = bytes.streamInput();){
                testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", stream, bytes.length(), true);
            }
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + String.valueOf(this.blobStore()) + "] is not accessible on the node [" + String.valueOf(localNode) + "]", exp);
        }
        try (InputStream masterDat = testBlobContainer.readBlob("master.dat");){
            String seedRead = Streams.readFully(masterDat).utf8ToString();
            if (!seedRead.equals(seed)) {
                throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
            }
        }
        catch (NoSuchFileException e) {
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + String.valueOf(this.blobStore()) + "] cannot be accessed on the node [" + String.valueOf(localNode) + "]. This might indicate that the store [" + String.valueOf(this.blobStore()) + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node", e);
        }
        catch (Exception e) {
            throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + String.valueOf(this.blobStore.get()) + "]]";
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, int snapshotShardId, Collection<SnapshotId> snapshotIds, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, long indexGeneration) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        String writtenGeneration = null;
        try {
            if (newSnapshotsList.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, "_deleted", blobs);
            }
            BlobStoreIndexShardSnapshots updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            if (indexGeneration < 0L) {
                writtenGeneration = UUIDs.randomBase64UUID();
                INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedSnapshots, shardContainer, writtenGeneration, this.compress);
            } else {
                writtenGeneration = String.valueOf(indexGeneration);
                this.writeShardIndexBlobAtomic(shardContainer, indexGeneration, updatedSnapshots);
            }
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, writtenGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots));
        }
        catch (IOException e) {
            throw new RepositoryException(this.metadata.name(), "Failed to finalize snapshot deletion " + String.valueOf(snapshotIds) + " with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(writtenGeneration) + "]", e);
        }
    }

    private void writeShardIndexBlobAtomic(BlobContainer shardContainer, long indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots) throws IOException {
        assert (indexGeneration >= 0L) : "Shard generation must not be negative but saw [" + indexGeneration + "]";
        LOGGER.trace(() -> new ParameterizedMessage("[{}] Writing shard index [{}] to [{}]", new Object[]{this.metadata.name(), indexGeneration, shardContainer.path()}));
        String blobName = INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(String.valueOf(indexGeneration));
        this.writeAtomic(shardContainer, blobName, INDEX_SHARD_SNAPSHOTS_FORMAT.serialize(updatedSnapshots, blobName, this.compress), true);
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots) {
        return blobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat") && !survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length())) || blob.startsWith(UPLOADED_DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).collect(Collectors.toList());
    }

    public BlobStoreIndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            return INDEX_SHARD_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedWriteableRegistry, this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + String.valueOf(shardContainer.path()) + "]", (Throwable)ex);
        }
    }

    private Tuple<BlobStoreIndexShardSnapshots, String> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable String generation) throws IOException {
        if (generation != null) {
            if (generation.equals("_new")) {
                return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)"_new");
            }
            return new Tuple((Object)INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, generation, this.namedWriteableRegistry, this.namedXContentRegistry), (Object)generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple((Object)((BlobStoreIndexShardSnapshots)legacyIndex.v1()), (Object)String.valueOf(legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, Long.toString(latest), this.namedWriteableRegistry, this.namedXContentRegistry);
            return new Tuple((Object)shardSnapshots, (Object)latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            LOGGER.warn("Could not find a readable index-N file in a non-empty shard snapshot directory [" + String.valueOf(shardContainer.path()) + "]");
        }
        return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.DEFAULT, fileInfo.metadata());){
            for (int i = 0; i < fileInfo.numberOfParts(); ++i) {
                long partBytes = fileInfo.partBytes(i);
                InputStream inputStream = new InputStreamIndexInput(indexInput, partBytes);
                inputStream = new FilterInputStream(this, this.maybeRateLimitSnapshots(inputStream)){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            LOGGER.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new AbortedSnapshotException();
                        }
                    }
                };
                String partName = fileInfo.partName(i);
                LOGGER.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to [{}]", new Object[]{this.metadata.name(), partName, shardContainer.path()}));
                shardContainer.writeBlob(partName, inputStream, partBytes, false);
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                LOGGER.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final String newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, String newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }
}

