/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.analyze.SnapshotSettings;
import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.PartitionAlreadyExistsException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TableOrPartition;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.jetbrains.annotations.VisibleForTesting;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger LOGGER = LogManager.getLogger(RestoreService.class);
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataUpgradeService metadataUpgradeService;
    private final ClusterSettings clusterSettings;
    private final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;
    private final ShardLimitValidator shardLimitValidator;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataUpgradeService metadataUpgradeService, ClusterSettings clusterSettings, ShardLimitValidator shardLimitValidator) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataUpgradeService = metadataUpgradeService;
        if (DiscoveryNode.isMasterEligibleNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterSettings;
        this.cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor(LOGGER);
        this.shardLimitValidator = shardLimitValidator;
    }

    public void restoreSnapshot(RestoreRequest request, List<TableOrPartition> tablesToRestore, ActionListener<RestoreCompletionResponse> listener) {
        Repository repository;
        String repositoryName = request.repositoryName;
        try {
            repository = this.repositoriesService.repository(repositoryName);
        }
        catch (Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repositoryName + ":" + request.snapshotName)), (Throwable)e);
            listener.onFailure(e);
            return;
        }
        ((CompletableFuture)repository.getRepositoryData().thenCompose(repositoryData -> {
            String snapshotName = request.snapshotName;
            Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
            }
            SnapshotId snapshotId = matchingSnapshotId.get();
            return repository.getSnapshotInfo(snapshotId).thenCompose(snapshotInfo -> {
                Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
                this.validateSnapshotRestorable(repositoryName, (SnapshotInfo)snapshotInfo);
                return repository.getSnapshotGlobalMetadata(snapshotId).thenCompose(originalGlobalMetadata -> {
                    Metadata globalMetadata = this.metadataUpgradeService.upgradeMetadata((Metadata)originalGlobalMetadata);
                    Metadata.Builder metadataBuilder = Metadata.builder(globalMetadata);
                    Map<RelationName, RestoreRelation> restoreRelations = RestoreService.resolveRelations(tablesToRestore, request, globalMetadata, snapshotInfo);
                    ArrayList<IndexId> indexIdsInSnapshot = new ArrayList<IndexId>();
                    for (Map.Entry<RelationName, RestoreRelation> entry : restoreRelations.entrySet()) {
                        RestoreRelation restoreRelation = entry.getValue();
                        for (RestoreIndex restoreIndex : restoreRelation.restoreIndices()) {
                            indexIdsInSnapshot.add(repositoryData.resolveIndexId(restoreIndex.index().getName()));
                        }
                    }
                    CompletableFuture<Collection<IndexMetadata>> futureSnapshotIndexMetadata = repository.getSnapshotIndexMetadata(globalMetadata, (RepositoryData)repositoryData, snapshotId, (Collection<IndexId>)indexIdsInSnapshot);
                    return futureSnapshotIndexMetadata.thenAccept(snapshotIndexMetadata -> {
                        for (IndexMetadata indexMetadata : snapshotIndexMetadata) {
                            metadataBuilder.put(indexMetadata, false);
                        }
                        Metadata metadata = metadataBuilder.build();
                        RestoreSnapshotUpdateTask updateTask = new RestoreSnapshotUpdateTask((SnapshotInfo)snapshotInfo, snapshotId, (RepositoryData)repositoryData, snapshot, listener, request, restoreRelations, metadata);
                        this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + "]", updateTask);
                    });
                });
            });
        })).exceptionally(t -> {
            listener.onFailure(Exceptions.toException((Throwable)t));
            return null;
        });
    }

    static Map<RelationName, RestoreRelation> resolveRelations(List<TableOrPartition> tablesToRestore, RestoreRequest request, Metadata snapshotMetadata, SnapshotInfo snapshotInfo) {
        HashMap<RelationName, RestoreRelation> restoreRelations;
        block5: {
            boolean strict = SnapshotSettings.IGNORE_UNAVAILABLE.get(request.settings) == false;
            restoreRelations = new HashMap<RelationName, RestoreRelation>();
            BiConsumer<RelationName, List> resolver = (relationName2, partitionValues) -> {
                List<RestoreIndex> restoreIndices;
                try {
                    restoreIndices = snapshotMetadata.getIndices((RelationName)relationName2, (List<String>)partitionValues, strict, im -> new RestoreIndex(im.getIndex(), im.partitionValues()));
                }
                catch (RelationUnknown e) {
                    throw new ResourceNotFoundException("Relation [{}] not found in snapshot", relationName2);
                }
                if (!partitionValues.isEmpty() && restoreIndices.isEmpty()) {
                    return;
                }
                RelationName renamedRelation = RestoreService.applyRenameToRelation(request, relationName2);
                restoreRelations.compute((RelationName)relationName2, (relationName, restoreRelation) -> {
                    if (restoreRelation == null) {
                        restoreRelation = new RestoreRelation(renamedRelation, new ArrayList<RestoreIndex>());
                    }
                    restoreRelation.add(restoreIndices);
                    return restoreRelation;
                });
            };
            for (TableOrPartition tableOrPartition : tablesToRestore) {
                List partitionValues2 = tableOrPartition.partitionIdent() == null ? List.of() : PartitionName.decodeIdent(tableOrPartition.partitionIdent());
                resolver.accept(tableOrPartition.table(), partitionValues2);
            }
            if (!tablesToRestore.isEmpty() || !request.includeTables()) break block5;
            if (snapshotInfo.version().before(Version.V_6_0_0)) {
                for (String indexName : snapshotInfo.indexNames()) {
                    IndexParts indexParts = IndexName.decode(indexName);
                    Index index = new Index(indexName, "_na_");
                    List partitionValues3 = indexParts.isPartitioned() ? PartitionName.decodeIdent(indexParts.partitionIdent()) : List.of();
                    RelationName relationName3 = indexParts.toRelationName();
                    RelationName renamedRelation = RestoreService.applyRenameToRelation(request, relationName3);
                    restoreRelations.compute(relationName3, (relationName, restoreRelation) -> {
                        if (restoreRelation == null) {
                            restoreRelation = new RestoreRelation(renamedRelation, new ArrayList<RestoreIndex>());
                        }
                        restoreRelation.add(List.of(new RestoreIndex(index, partitionValues3)));
                        return restoreRelation;
                    });
                }
            } else {
                for (RelationMetadata.Table relation : snapshotMetadata.relations(RelationMetadata.Table.class)) {
                    resolver.accept(relation.name(), List.of());
                }
            }
        }
        return restoreRelations;
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return state.custom("restore", RestoreInProgress.EMPTY).get(restoreUUID);
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        for (RestoreInProgress.Entry entry : event.state().custom("restore", RestoreInProgress.EMPTY)) {
            if (!entry.state().completed()) continue;
            assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
            this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build(Priority.URGENT), this.cleanRestoreStateTaskExecutor, this.cleanRestoreStateTaskExecutor);
        }
    }

    public static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor status : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private static RelationName applyRenameToRelation(RestoreRequest request, RelationName relationName) {
        boolean applyRenamePattern = request.hasNonDefaultRenamePatterns();
        RelationName renamed = relationName;
        if (applyRenamePattern) {
            String schema = relationName.schema();
            String table = relationName.name();
            table = table.replaceAll(request.tableRenamePattern(), request.tableRenameReplacement());
            schema = schema.replaceAll(request.schemaRenamePattern(), request.schemaRenameReplacement());
            renamed = new RelationName(schema, table);
        }
        return renamed;
    }

    private void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + String.valueOf((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with CrateDB version [" + String.valueOf(snapshotInfo.version()) + "] which is higher than the version of this node [" + String.valueOf(Version.CURRENT) + "]");
        }
    }

    private boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Collection<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                Index index = ((ShardId)objectObjectCursor.key).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || currentState.metadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            LOGGER.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final Logger logger;

        CleanRestoreStateTaskExecutor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            boolean changed = false;
            for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
                if (completedRestores.contains(entry.uuid())) {
                    changed = true;
                    continue;
                }
                restoreInProgressBuilder.add(entry);
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.customs());
            builder.put("restore", restoreInProgressBuilder.build());
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }

    public record RestoreRequest(String repositoryName, String snapshotName, IndicesOptions indicesOptions, Settings settings, TimeValue masterNodeTimeout, boolean includeTables, boolean includeCustomMetadata, String[] customMetadataTypes, boolean includeGlobalSettings, String[] globalSettings) {
        public String tableRenamePattern() {
            return SnapshotSettings.TABLE_RENAME_PATTERN.get(this.settings);
        }

        public String tableRenameReplacement() {
            return SnapshotSettings.TABLE_RENAME_REPLACEMENT.get(this.settings);
        }

        public String schemaRenamePattern() {
            return SnapshotSettings.SCHEMA_RENAME_PATTERN.get(this.settings);
        }

        public String schemaRenameReplacement() {
            return SnapshotSettings.SCHEMA_RENAME_REPLACEMENT.get(this.settings);
        }

        public boolean hasNonDefaultRenamePatterns() {
            return SnapshotSettings.TABLE_RENAME_PATTERN.exists(this.settings) || SnapshotSettings.TABLE_RENAME_REPLACEMENT.exists(this.settings) || SnapshotSettings.SCHEMA_RENAME_PATTERN.exists(this.settings) || SnapshotSettings.SCHEMA_RENAME_REPLACEMENT.exists(this.settings);
        }
    }

    @VisibleForTesting
    record RestoreRelation(RelationName targetName, List<RestoreIndex> restoreIndices) {
        public void add(List<RestoreIndex> newIndexUUIDs) {
            this.restoreIndices.addAll(newIndexUUIDs);
        }
    }

    @VisibleForTesting
    record RestoreIndex(Index index, List<String> partitionValues) {
    }

    private final class RestoreSnapshotUpdateTask
    extends ClusterStateUpdateTask {
        private final SnapshotInfo snapshotInfo;
        private final SnapshotId snapshotId;
        private final RepositoryData repositoryData;
        private final Snapshot snapshot;
        private final ActionListener<RestoreCompletionResponse> listener;
        private final RestoreRequest request;
        private final Map<RelationName, RestoreRelation> restoreRelations;
        private final Metadata snapshotMetadata;
        final String restoreUUID = UUIDs.randomBase64UUID();
        RestoreInfo restoreInfo = null;

        private RestoreSnapshotUpdateTask(SnapshotInfo snapshotInfo, SnapshotId snapshotId, RepositoryData repositoryData, Snapshot snapshot, ActionListener<RestoreCompletionResponse> listener, RestoreRequest request, Map<RelationName, RestoreRelation> restoreRelations, Metadata snapshotMetadata) {
            this.snapshotInfo = snapshotInfo;
            this.snapshotId = snapshotId;
            this.repositoryData = repositoryData;
            this.snapshot = snapshot;
            this.listener = listener;
            this.request = request;
            this.restoreRelations = restoreRelations;
            this.snapshotMetadata = RestoreService.this.metadataUpgradeService.upgradeMetadata(snapshotMetadata);
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(this.snapshotId))) {
                throw new ConcurrentSnapshotExecutionException(this.snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + String.valueOf(deletionsInProgress.getEntries().get(0)) + "]");
            }
            ClusterState.Builder builder = ClusterState.builder(currentState);
            Metadata currentMetadata = currentState.metadata();
            Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
            boolean ignoreUnavailable = SnapshotSettings.IGNORE_UNAVAILABLE.get(this.request.settings);
            HashSet<String> restoreIndexNames = new HashSet<String>();
            for (Map.Entry<RelationName, RestoreRelation> entry2 : this.restoreRelations.entrySet()) {
                RelationName relationName = entry2.getKey();
                RestoreRelation restoreRelation = entry2.getValue();
                RelationName targetName = restoreRelation.targetName();
                ArrayList<String> newIndexUUIDs = new ArrayList<String>();
                for (RestoreIndex restoreIndex : restoreRelation.restoreIndices()) {
                    Index renamedIndex;
                    IndexMetadata snapshotIndexMetadata;
                    String sourceIndexName = restoreIndex.index().getName();
                    String targetIndexName = restoreIndex.partitionValues().isEmpty() ? targetName.indexNameOrAlias() : new PartitionName(targetName, restoreIndex.partitionValues()).asIndexName();
                    this.ensureNotPartial(targetIndexName);
                    RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, this.snapshot, this.snapshotInfo.version(), this.repositoryData.resolveIndexId(sourceIndexName));
                    if (this.snapshotInfo.version().before(Version.V_6_0_0)) {
                        snapshotIndexMetadata = this.snapshotMetadata.getIndex(relationName, restoreIndex.partitionValues(), !ignoreUnavailable, im -> im);
                    } else {
                        Index index = restoreIndex.index();
                        snapshotIndexMetadata = this.snapshotMetadata.index(index);
                    }
                    if (snapshotIndexMetadata == null) {
                        throw new IndexNotFoundException("Failed to find index '" + targetIndexName + "' at the metadata of the current snapshot '" + String.valueOf(this.snapshot) + "'", targetIndexName);
                    }
                    IndexMetadata currentIndexMetadata = currentMetadata.getIndex(targetName, restoreIndex.partitionValues(), false, im -> im);
                    if (currentIndexMetadata == null) {
                        IndexName.validate(targetIndexName);
                        RestoreService.this.createIndexService.validateIndexSettings(targetIndexName, snapshotIndexMetadata.getSettings(), false);
                        newIndexUUID = UUIDs.randomBase64UUID();
                        indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                        newIndexUUIDs.add(newIndexUUID);
                        Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", newIndexUUID);
                        if (snapshotIndexMetadata.getCreationVersion().onOrAfter(Version.V_5_1_0) || currentState.nodes().getMinNodeVersion().onOrAfter(Version.V_5_1_0)) {
                            indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
                        }
                        indexMdBuilder.settings(indexSettingsBuilder).indexName(targetIndexName).indexUUID(newIndexUUID);
                        RestoreService.this.shardLimitValidator.validateShardLimit(snapshotIndexMetadata.getSettings(), currentState);
                        IndexMetadata updatedIndexMetadata = indexMdBuilder.build();
                        rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource);
                        blocks.addBlocks(updatedIndexMetadata);
                        mdBuilder.put(updatedIndexMetadata, true);
                        renamedIndex = updatedIndexMetadata.getIndex();
                    } else {
                        this.validateExistingIndex(targetName, currentIndexMetadata, snapshotIndexMetadata, targetIndexName);
                        indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                        indexMdBuilder.version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion()));
                        indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion()));
                        indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion()));
                        for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                            indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
                        }
                        newIndexUUID = currentIndexMetadata.getIndexUUID();
                        newIndexUUIDs.add(newIndexUUID);
                        indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", newIndexUUID));
                        IndexMetadata updatedIndexMetadata = indexMdBuilder.indexName(targetIndexName).build();
                        rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                        blocks.updateBlocks(updatedIndexMetadata);
                        mdBuilder.put(updatedIndexMetadata, true);
                        renamedIndex = updatedIndexMetadata.getIndex();
                    }
                    restoreIndexNames.add(renamedIndex.getName());
                    for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                        shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                    }
                }
                this.restoreRelation(relationName, targetName, mdBuilder, currentMetadata, newIndexUUIDs, !ignoreUnavailable);
            }
            ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
            if (!shards.isEmpty()) {
                RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, this.snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), restoreIndexNames.stream().toList(), shards);
                builder.putCustom("restore", new RestoreInProgress.Builder(currentState.custom("restore", RestoreInProgress.EMPTY)).add(restoreEntry).build());
            }
            if (this.request.includeGlobalSettings() && this.snapshotMetadata.persistentSettings() != null) {
                Settings settings = this.snapshotMetadata.persistentSettings();
                if (this.request.globalSettings().length > 0) {
                    Settings.Builder filteredSettingBuilder = Settings.builder();
                    for (String prefix : this.request.globalSettings()) {
                        filteredSettingBuilder.put(settings.filter(s -> s.startsWith(prefix)));
                    }
                    settings = filteredSettingBuilder.build();
                }
                RestoreService.this.clusterSettings.validateUpdate(settings);
                mdBuilder.persistentSettings(settings);
            }
            if (this.request.includeCustomMetadata() && this.snapshotMetadata.customs() != null) {
                List<String> customMetadataTypes = Arrays.asList(this.request.customMetadataTypes());
                boolean includeAll = customMetadataTypes.isEmpty();
                for (ObjectObjectCursor objectObjectCursor : this.snapshotMetadata.customs()) {
                    if ("repositories".equals(objectObjectCursor.key) || !includeAll && !customMetadataTypes.contains(objectObjectCursor.key)) continue;
                    mdBuilder.putCustom((String)objectObjectCursor.key, (Metadata.Custom)objectObjectCursor.value);
                }
            }
            if (RestoreService.completed(shards)) {
                this.restoreInfo = new RestoreInfo(this.snapshotId.getName(), restoreIndexNames.stream().toList(), shards.size(), shards.size() - RestoreService.failedShards(shards));
            }
            RoutingTable rt = rtBuilder.build();
            ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
            return RestoreService.this.allocationService.reroute(updatedState, "restored snapshot [" + String.valueOf(this.snapshot) + "]");
        }

        private void restoreRelation(RelationName relationName, RelationName targetName, Metadata.Builder mdBuilder, Metadata currentMetadata, List<String> indexUUIDs, boolean strict) {
            Object existingRelation = currentMetadata.getRelation(targetName);
            Object snapshotRelation = this.snapshotMetadata.getRelation(relationName);
            if (snapshotRelation == null) {
                if (strict) {
                    throw new ResourceNotFoundException("Relation [{}] not found in snapshot", relationName);
                }
                return;
            }
            if (existingRelation instanceof RelationMetadata.Table) {
                RelationMetadata.Table snapshotTable;
                RelationMetadata.Table existingTable = (RelationMetadata.Table)existingRelation;
                RelationMetadata.Table table = snapshotRelation instanceof RelationMetadata.Table ? (snapshotTable = (RelationMetadata.Table)snapshotRelation) : existingTable;
                LongSupplier columnOidSupplier = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(table.settings()).before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : mdBuilder.columnOidSupplier();
                mdBuilder.setTable(columnOidSupplier, targetName, Lists.map(table.columns(), ref -> ref.withReferenceIdent(new ReferenceIdent(targetName, ref.column()))), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), Lists.concatUnique(existingTable.indexUUIDs(), indexUUIDs), table.tableVersion());
            } else if (existingRelation == null) {
                if (snapshotRelation instanceof RelationMetadata.Table) {
                    RelationMetadata.Table table = (RelationMetadata.Table)snapshotRelation;
                    LongSupplier columnOidSupplier = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(table.settings()).before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : mdBuilder.columnOidSupplier();
                    mdBuilder.setTable(columnOidSupplier, targetName, Lists.map(table.columns(), ref -> ref.withReferenceIdent(new ReferenceIdent(targetName, ref.column()))), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), indexUUIDs, table.tableVersion());
                }
            } else {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot restore relation `%s` as `%s`, it conflicts with: %s", relationName, targetName, existingRelation));
            }
        }

        private void ensureNotPartial(String index) {
            if (RestoreService.this.failed(this.snapshotInfo, index)) {
                throw new SnapshotRestoreException(this.snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
            }
        }

        private void validateExistingIndex(RelationName targetName, IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex) {
            if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                if (currentIndexMetadata.partitionValues().isEmpty()) {
                    throw new RelationAlreadyExists(targetName);
                }
                throw new PartitionAlreadyExistsException(new PartitionName(targetName, PartitionName.encodeIdent(currentIndexMetadata.partitionValues())));
            }
            if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)this.snapshotId), (Throwable)e);
            this.listener.onFailure(e);
        }

        @Override
        public TimeValue timeout() {
            return this.request.masterNodeTimeout();
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, this.snapshot, this.restoreInfo));
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Updates> shardChanges = new HashMap<String, Updates>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes((RecoverySource)recoverySource).shards.put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes((RecoverySource)recoverySource).shards.put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes((RecoverySource)unassignedShard.recoverySource()).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + String.valueOf(initializedShard.recoverySource())));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes((RecoverySource)recoverySource).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Updates changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), string -> new Updates());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Updates updates = this.shardChanges.get(entry.uuid());
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.shards.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.shards.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }

        private static class Updates {
            private Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();

            private Updates() {
            }
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

