/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import io.crate.server.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.jetbrains.annotations.Nullable;

public final class SnapshotInfo
implements Comparable<SnapshotInfo>,
Writeable {
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = "SNAPSHOT";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INDICES = "indices";
    private static final String STATE = "state";
    private static final String REASON = "reason";
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";
    private static final String FAILURES = "failures";
    private static final String VERSION_ID = "version_id";
    private static final String NAME = "name";
    private static final String TOTAL_SHARDS = "total_shards";
    private static final String SUCCESSFUL_SHARDS = "successful_shards";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final Comparator<SnapshotInfo> COMPARATOR = Comparator.comparing(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    private final SnapshotId snapshotId;
    @Nullable
    private final SnapshotState state;
    @Nullable
    private final String reason;
    private final List<String> indices;
    private final long startTime;
    private final long endTime;
    private final int totalShards;
    private final int successfulShards;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final Version version;
    private final List<SnapshotShardFailure> shardFailures;

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, SnapshotState state) {
        this(snapshotId, indices, state, null);
    }

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, SnapshotState state, Version version) {
        this(snapshotId, indices, state, null, version, 0L, 0L, 0, 0, Collections.emptyList(), null);
    }

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, long startTime, String reason, long endTime, int totalShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState) {
        this(snapshotId, indices, SnapshotInfo.snapshotState(reason, shardFailures), reason, Version.CURRENT, startTime, endTime, totalShards, totalShards - shardFailures.size(), shardFailures, includeGlobalState);
    }

    SnapshotInfo(SnapshotId snapshotId, List<String> indices, SnapshotState state, String reason, Version version, long startTime, long endTime, int totalShards, int successfulShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState) {
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.shardFailures = Objects.requireNonNull(shardFailures);
        this.includeGlobalState = includeGlobalState;
    }

    public SnapshotInfo(StreamInput in) throws IOException {
        this.snapshotId = new SnapshotId(in);
        this.indices = Collections.unmodifiableList(in.readStringList());
        this.state = in.readBoolean() ? SnapshotState.fromValue(in.readByte()) : null;
        this.reason = in.readOptionalString();
        this.startTime = in.readVLong();
        this.endTime = in.readVLong();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.shardFailures = Collections.unmodifiableList(in.readList(SnapshotShardFailure::new));
        this.version = in.readBoolean() ? Version.readVersion(in) : null;
        this.includeGlobalState = in.readOptionalBoolean();
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public SnapshotState state() {
        return this.state;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public List<String> indexNames() {
        return this.indices;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Nullable
    public Version version() {
        return this.version;
    }

    @Override
    public int compareTo(SnapshotInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "SnapshotInfo{snapshotId=" + String.valueOf(this.snapshotId) + ", state=" + String.valueOf((Object)this.state) + ", reason='" + this.reason + "', indices=" + String.valueOf(this.indices) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", includeGlobalState=" + this.includeGlobalState + ", version=" + String.valueOf(this.version) + ", shardFailures=" + String.valueOf(this.shardFailures) + "}";
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    public static SnapshotInfo fromXContentInternal(XContentParser parser) throws IOException {
        String name = null;
        String uuid = null;
        Version version = Version.CURRENT;
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShards = 0;
        int successfulShards = 0;
        Boolean includeGlobalState = null;
        List<SnapshotShardFailure> shardFailures = Collections.emptyList();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String currentFieldName = parser.currentName();
        if (SNAPSHOT.equals(currentFieldName)) {
            XContentParser.Token token;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (token.isValue()) {
                    if (NAME.equals(currentFieldName)) {
                        name = parser.text();
                        continue;
                    }
                    if (UUID.equals(currentFieldName)) {
                        uuid = parser.text();
                        continue;
                    }
                    if (STATE.equals(currentFieldName)) {
                        state = SnapshotState.valueOf(parser.text());
                        continue;
                    }
                    if (REASON.equals(currentFieldName)) {
                        reason = parser.text();
                        continue;
                    }
                    if (START_TIME.equals(currentFieldName)) {
                        startTime = parser.longValue();
                        continue;
                    }
                    if (END_TIME.equals(currentFieldName)) {
                        endTime = parser.longValue();
                        continue;
                    }
                    if (TOTAL_SHARDS.equals(currentFieldName)) {
                        totalShards = parser.intValue();
                        continue;
                    }
                    if (SUCCESSFUL_SHARDS.equals(currentFieldName)) {
                        successfulShards = parser.intValue();
                        continue;
                    }
                    if (VERSION_ID.equals(currentFieldName)) {
                        version = Version.fromId(parser.intValue());
                        continue;
                    }
                    if (!INCLUDE_GLOBAL_STATE.equals(currentFieldName)) continue;
                    includeGlobalState = parser.booleanValue();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (INDICES.equals(currentFieldName)) {
                        ArrayList<String> indicesArray = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            indicesArray.add(parser.text());
                        }
                        indices = Collections.unmodifiableList(indicesArray);
                        continue;
                    }
                    if (FAILURES.equals(currentFieldName)) {
                        ArrayList<SnapshotShardFailure> shardFailureArrayList = new ArrayList<SnapshotShardFailure>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            shardFailureArrayList.add(SnapshotShardFailure.fromXContent(parser));
                        }
                        shardFailures = Collections.unmodifiableList(shardFailureArrayList);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                parser.skipChildren();
            }
        }
        if (uuid == null) {
            uuid = name;
        }
        return new SnapshotInfo(new SnapshotId(name, uuid), indices, state, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshotId.writeTo(out);
        out.writeStringCollection(this.indices);
        if (this.state != null) {
            out.writeBoolean(true);
            out.writeByte(this.state.value());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeList(this.shardFailures);
        if (this.version != null) {
            out.writeBoolean(true);
            Version.writeVersion(this.version, out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.includeGlobalState);
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.snapshotId, that.snapshotId) && this.state == that.state && Objects.equals(this.reason, that.reason) && Objects.equals(this.indices, that.indices) && Objects.equals(this.includeGlobalState, that.includeGlobalState) && Objects.equals(this.version, that.version) && Objects.equals(this.shardFailures, that.shardFailures);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.state, this.reason, this.indices, this.startTime, this.endTime, this.totalShards, this.successfulShards, this.includeGlobalState, this.version, this.shardFailures});
    }
}

