/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.Tuple;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusResponse;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger LOGGER = LogManager.getLogger(SnapshotsService.class);
    public static final Version FULL_CONCURRENCY_VERSION = Version.V_5_2_0;
    public static final Version SHARD_GEN_IN_REPO_DATA_VERSION = Version.V_4_2_0;
    public static final Version OLD_SNAPSHOT_FORMAT = Version.V_4_1_0;
    public static final Version MULTI_DELETE_VERSION = Version.V_5_1_0;
    public static final Version INDEX_GEN_IN_REPO_DATA_VERSION = Version.V_5_2_0;
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>>();
    private final Map<String, List<ActionListener<Void>>> snapshotDeletionListeners = new HashMap<String, List<ActionListener<Void>>>();
    private final Set<String> currentlyFinalizing = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());
    private final SnapshotStateExecutor snapshotStateExecutor = new SnapshotStateExecutor();
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;
    private final TransportService transportService;
    private final OngoingRepositoryOperations repositoryOperations = new OngoingRepositoryOperations();
    public static final Setting<Integer> MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING = Setting.intSetting("snapshot.max_concurrent_operations", 1000, 1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile int maxConcurrentOperations;

    public SnapshotsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, this.threadPool);
        if (DiscoveryNode.isMasterEligibleNode(settings)) {
            clusterService.addLowPriorityApplier(this);
            this.maxConcurrentOperations = MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING, i -> {
                this.maxConcurrentOperations = i;
            });
        }
    }

    public void executeSnapshot(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(request, ActionListener.wrap(snapshot -> this.addListener((Snapshot)snapshot, listener.map(Tuple::v2)), listener::onFailure));
    }

    public void createSnapshot(CreateSnapshotRequest request, ActionListener<Snapshot> listener) {
        String repositoryName = request.repository();
        String snapshotName = request.snapshot();
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Repository repository = this.repositoriesService.repository(request.repository());
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository"));
            return;
        }
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(this, (RepositoryData)repositoryData, snapshotName, repository, repositoryName, request, snapshotId, listener, snapshot){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ String val$repositoryName;
            final /* synthetic */ CreateSnapshotRequest val$request;
            final /* synthetic */ SnapshotId val$snapshotId;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ Snapshot val$snapshot;
            final /* synthetic */ SnapshotsService this$0;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string;
                this.val$repository = repository;
                this.val$repositoryName = string2;
                this.val$request = createSnapshotRequest;
                this.val$snapshotId = snapshotId;
                this.val$listener = actionListener;
                this.val$snapshot = snapshot;
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (this.val$repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(this.val$snapshotName))) {
                    throw new InvalidSnapshotNameException(this.val$repository.getMetadata().name(), this.val$snapshotName, "snapshot with the same name already exists");
                }
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                List<SnapshotsInProgress.Entry> runningSnapshots = snapshots.entries();
                if (runningSnapshots.stream().anyMatch(s -> {
                    Snapshot running = s.snapshot();
                    return running.getRepository().equals(this.val$repositoryName) && running.getSnapshotId().getName().equals(this.val$snapshotName);
                })) {
                    throw new InvalidSnapshotNameException(this.val$repository.getMetadata().name(), this.val$snapshotName, "snapshot with the same name is already in-progress");
                }
                SnapshotsService.validate(this.val$repositoryName, this.val$snapshotName, currentState);
                boolean concurrentOperationsAllowed = currentState.nodes().getMinNodeVersion().onOrAfter(FULL_CONCURRENCY_VERSION);
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (deletionsInProgress.hasDeletionsInProgress() && !concurrentOperationsAllowed) {
                    throw new ConcurrentSnapshotExecutionException(this.val$repositoryName, this.val$snapshotName, "cannot snapshot while a snapshot deletion is in-progress in [" + String.valueOf(deletionsInProgress) + "]");
                }
                if (!concurrentOperationsAllowed && runningSnapshots.stream().anyMatch(entry -> entry.state() != SnapshotsInProgress.State.INIT)) {
                    throw new ConcurrentSnapshotExecutionException(this.val$repositoryName, this.val$snapshotName, " a snapshot is already running");
                }
                this.this$0.ensureBelowConcurrencyLimit(this.val$repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                HashSet<Index> indices = new HashSet<Index>();
                HashSet<RelationName> relationNames = new HashSet<RelationName>(this.val$request.relationNames());
                Metadata metadata = currentState.metadata();
                Iterable<Object> relationsMetadata = this.val$request.relationNames().isEmpty() && this.val$request.partitionNames().isEmpty() ? metadata.relations(RelationMetadata.Table.class) : () -> this.val$request.relationNames().stream().map(r -> metadata.getRelation((RelationName)r)).filter(r -> r instanceof RelationMetadata.Table).map(r -> (RelationMetadata.Table)r).iterator();
                for (RelationMetadata.Table table : relationsMetadata) {
                    relationNames.add(table.name());
                    List<Index> relationIndices = metadata.getIndices(table.name(), List.of(), false, IndexMetadata::getIndex);
                    indices.addAll(relationIndices);
                }
                for (PartitionName partitionName : this.val$request.partitionNames()) {
                    relationNames.add(partitionName.relationName());
                    List<Index> partitionIndices = metadata.getIndices(partitionName.relationName(), partitionName.values(), false, IndexMetadata::getIndex);
                    indices.addAll(partitionIndices);
                }
                LOGGER.trace("[{}][{}] creating snapshot for indices [{}]", (Object)this.val$repositoryName, (Object)this.val$snapshotName, indices);
                List<IndexId> indexIds = this.val$repositoryData.resolveNewIndices(indices, runningSnapshots.stream().filter(entry -> entry.repository().equals(this.val$repositoryName)).flatMap(entry -> entry.indices().stream()).distinct().collect(Collectors.toMap(IndexId::getName, Function.identity())));
                Version version = this.this$0.minCompatibleVersion(currentState.nodes().getMinNodeVersion(), this.val$repositoryData, null);
                ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.shards(snapshots, deletionsInProgress, metadata, currentState.routingTable(), indexIds, SnapshotsService.useShardGenerations(version), this.val$repositoryData, this.val$repositoryName);
                if (!this.val$request.partial()) {
                    HashSet<String> missing = new HashSet<String>();
                    for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : shards) {
                        if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.MISSING) continue;
                        missing.add(((ShardId)objectObjectCursor.key).getIndex().getUUID());
                    }
                    if (!missing.isEmpty()) {
                        throw new SnapshotException(new Snapshot(this.val$repositoryName, this.val$snapshotId), "Indices don't have primary shards " + String.valueOf(missing));
                    }
                }
                this.newEntry = SnapshotsInProgress.startedEntry(new Snapshot(this.val$repositoryName, this.val$snapshotId), this.val$request.includeGlobalState(), this.val$request.partial(), indexIds, relationNames.stream().toList(), this.this$0.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), shards, version);
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(runningSnapshots);
                newEntries.add(this.newEntry);
                return ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(new ArrayList<SnapshotsInProgress.Entry>(newEntries))).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}][{}] failed to create snapshot", (Object)this.val$repositoryName, (Object)this.val$snapshotName), (Throwable)e);
                this.val$listener.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    LOGGER.info("snapshot [{}] started", (Object)this.val$snapshot);
                    this.val$listener.onResponse(this.val$snapshot);
                }
                finally {
                    if (this.newEntry.state().completed()) {
                        this.this$0.endSnapshot(this.newEntry, newState.metadata(), this.val$repositoryData);
                    }
                }
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.masterNodeTimeout();
            }
        }, "create_snapshot [" + snapshotName + "]", listener::onFailure);
    }

    private void ensureBelowConcurrencyLimit(String repository, String name, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress) {
        int maxOps;
        int inProgressOperations = snapshotsInProgress.entries().size() + deletionsInProgress.getEntries().size();
        if (inProgressOperations >= (maxOps = this.maxConcurrentOperations)) {
            throw new ConcurrentSnapshotExecutionException(repository, name, "Cannot start another operation, already running [" + inProgressOperations + "] operations and the current limit for concurrent snapshot operations is set to [" + maxOps + "]");
        }
    }

    private static void validate(String repositoryName, String snapshotName, ClusterState state) {
        RepositoriesMetadata repositoriesMetadata = (RepositoriesMetadata)state.metadata().custom("repositories");
        if (repositoriesMetadata == null || repositoriesMetadata.repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsService.validate(repositoryName, snapshotName);
    }

    private static void validate(String repositoryName, String snapshotName) {
        if (!Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
    }

    private static ShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        HashMap indexLookup = new HashMap();
        snapshot.indices().forEach(idx -> indexLookup.put(idx.getName(), idx));
        snapshot.shards().forEach(c -> {
            if (metadata.index(((ShardId)c.key).getIndex()) == null) {
                assert (snapshot.partial()) : "Index [" + String.valueOf(((ShardId)c.key).getIndex()) + "] was deleted during a snapshot but snapshot was not partial.";
                return;
            }
            IndexId indexId = (IndexId)indexLookup.get(((ShardId)c.key).getIndexName());
            if (indexId != null) {
                builder.put(indexId, ((ShardId)c.key).id(), ((SnapshotsInProgress.ShardSnapshotStatus)c.value).generation());
            }
        });
        return builder.build();
    }

    private static Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        Metadata.Builder builder;
        if (!snapshot.includeGlobalState()) {
            builder = Metadata.builder();
            ArrayList<String> allIndexUUIDs = new ArrayList<String>();
            for (IndexId index : snapshot.indices()) {
                IndexMetadata indexMetadata = metadata.getIndexByName(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + String.valueOf(index) + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
                allIndexUUIDs.add(indexMetadata.getIndexUUID());
            }
            for (RelationName relationName : snapshot.relationNames()) {
                Object relation = metadata.getRelation(relationName);
                if (relation == null) continue;
                List<String> indexUUIDs = relation.indexUUIDs().stream().filter(allIndexUUIDs::contains).toList();
                relation = relation.withIndexUUIDs(indexUUIDs);
                builder.setRelation((RelationMetadata)relation);
            }
        } else {
            builder = Metadata.builder(metadata);
        }
        return builder.build();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                SnapshotsInProgress snapshotsInProgress = event.state().custom("snapshots", SnapshotsInProgress.EMPTY);
                boolean newMaster = !event.previousState().nodes().isLocalNodeElectedMaster();
                this.processExternalChanges(newMaster || SnapshotsService.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes()), event.routingTableChanged() && SnapshotsService.waitingShardsStartedOrUnassigned(snapshotsInProgress, event));
            } else if (!this.snapshotCompletionListeners.isEmpty()) {
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    if (!this.endingSnapshots.add(snapshot)) continue;
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"));
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            LOGGER.warn("Failed to update snapshot state ", (Throwable)e);
        }
        assert (this.assertConsistentWithClusterState(event.state()));
        assert (SnapshotsService.assertNoDanglingSnapshots(event.state()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotDeletionsInProgress snapshotDeletionsInProgress;
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        if (!snapshotsInProgress.entries().isEmpty()) {
            Set<Snapshot> set = this.endingSnapshots;
            synchronized (set) {
                Set runningSnapshots = Stream.concat(snapshotsInProgress.entries().stream().map(SnapshotsInProgress.Entry::snapshot), this.endingSnapshots.stream()).collect(Collectors.toSet());
                Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
                assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + String.valueOf(snapshotListenerKeys) + " but running snapshots are " + String.valueOf(runningSnapshots);
            }
        }
        if ((snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY)).hasDeletionsInProgress()) {
            Set<String> set = this.repositoryOperations.runningDeletions;
            synchronized (set) {
                Set runningDeletes = Stream.concat(snapshotDeletionsInProgress.getEntries().stream().map(SnapshotDeletionsInProgress.Entry::uuid), this.repositoryOperations.runningDeletions.stream()).collect(Collectors.toSet());
                Set<String> deleteListenerKeys = this.snapshotDeletionListeners.keySet();
                assert (runningDeletes.containsAll(deleteListenerKeys)) : "Saw deletions listeners for unknown uuids in " + String.valueOf(deleteListenerKeys) + " but running deletes are " + String.valueOf(runningDeletes);
            }
        }
        return true;
    }

    private static boolean assertNoDanglingSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        SnapshotDeletionsInProgress snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        Set reposWithRunningDelete = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
        HashSet<String> reposSeen = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.entries()) {
            if (!reposSeen.add(entry2.repository())) continue;
            for (ObjectCursor value : entry2.shards().values()) {
                if (((SnapshotsInProgress.ShardSnapshotStatus)value.value).equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) assert (reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot waiting to be assigned in [" + String.valueOf(entry2) + "] but it is not blocked by any running delete";
            }
        }
        return true;
    }

    private void processExternalChanges(final boolean changedNodes, boolean startShards) {
        if (!changedNodes && !startShards) {
            return;
        }
        this.clusterService.submitStateUpdateTask("update snapshot after shards started [" + startShards + "] or node configuration changed [" + changedNodes + "]", new ClusterStateUpdateTask(this){
            private final Collection<SnapshotsInProgress.Entry> finishedSnapshots = new ArrayList<SnapshotsInProgress.Entry>();
            private final Collection<SnapshotDeletionsInProgress.Entry> deletionsToExecute = new ArrayList<SnapshotDeletionsInProgress.Entry>();
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable routingTable = currentState.routingTable();
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                DiscoveryNodes nodes = currentState.nodes();
                boolean changed = false;
                EnumSet<SnapshotsInProgress.State> statesToUpdate = changedNodes ? EnumSet.of(SnapshotsInProgress.State.STARTED, SnapshotsInProgress.State.ABORTED) : EnumSet.of(SnapshotsInProgress.State.STARTED);
                ArrayList<SnapshotsInProgress.Entry> updatedSnapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
                HashMap<String, Map> knownFailures = new HashMap<String, Map>();
                for (SnapshotsInProgress.Entry snapshot : snapshots.entries()) {
                    if (statesToUpdate.contains((Object)snapshot.state())) {
                        ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsService.processWaitingShardsAndRemovedNodes(snapshot.shards(), routingTable, nodes, knownFailures.computeIfAbsent(snapshot.repository(), k -> new HashMap()));
                        if (shards != null) {
                            SnapshotsInProgress.Entry updatedSnapshot = snapshot.withShardStates(shards);
                            changed = true;
                            if (updatedSnapshot.state().completed()) {
                                this.finishedSnapshots.add(updatedSnapshot);
                            }
                            updatedSnapshotEntries.add(updatedSnapshot);
                            continue;
                        }
                        updatedSnapshotEntries.add(snapshot);
                        continue;
                    }
                    if (snapshot.repositoryStateId() == -2L) {
                        changed = true;
                        LOGGER.debug("[{}] was found in dangling INIT or ABORTED state", (Object)snapshot);
                        continue;
                    }
                    if (snapshot.state().completed() || SnapshotsInProgress.completed(snapshot.shards().values())) {
                        this.finishedSnapshots.add(snapshot);
                    }
                    updatedSnapshotEntries.add(snapshot);
                }
                ClusterState res = (ClusterState)SnapshotsService.readyDeletions(changed ? ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(Collections.unmodifiableList(updatedSnapshotEntries))).build() : currentState).v1();
                for (SnapshotDeletionsInProgress.Entry delete : res.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
                    if (delete.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionsToExecute.add(delete);
                }
                return res;
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("failed to update snapshot state after shards started or nodes removed from [{}] ", (Object)source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotDeletionsInProgress snapshotDeletionsInProgress = newState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (!this.finishedSnapshots.isEmpty()) {
                    Set reposWithRunningDeletes = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
                    for (SnapshotsInProgress.Entry entry2 : this.finishedSnapshots) {
                        if (reposWithRunningDeletes.contains(entry2.repository())) continue;
                        this.this$0.endSnapshot(entry2, newState.metadata(), null);
                    }
                }
                for (SnapshotDeletionsInProgress.Entry entry3 : this.deletionsToExecute) {
                    if (!this.this$0.tryEnterRepoLoop(entry3.repository())) continue;
                    this.this$0.deleteSnapshotsFromRepository(entry3, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShardsAndRemovedNodes(ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> snapshotShards, RoutingTable routingTable, DiscoveryNodes nodes, Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures) {
        boolean snapshotChanged = false;
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : snapshotShards) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
            ShardId shardId = (ShardId)objectObjectCursor.key;
            if (shardStatus.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                SnapshotsInProgress.ShardSnapshotStatus knownFailure = knownFailures.get(shardId);
                if (knownFailure == null) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                shards.put(shardId, knownFailure);
                continue;
            }
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null && shardRouting.primaryShard() != null) {
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        LOGGER.trace("starting shard that we were waiting for [{}] on node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardRouting.primaryShard().currentNodeId(), shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                LOGGER.warn("failing snapshot of shard [{}] on unassigned shard [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "shard is unassigned", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put(shardId, failedState);
                continue;
            }
            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                if (nodes.nodeExists(shardStatus.nodeId())) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                LOGGER.warn("failing snapshot of shard [{}] on closed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "node shutdown", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put(shardId, failedState);
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return shards.build();
        }
        return null;
    }

    private static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterChangedEvent event) {
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            if (entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId;
                if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.WAITING || !event.indexRoutingTableChanged((shardId = (ShardId)objectObjectCursor.key).getIndexUUID())) continue;
                IndexRoutingTable indexShardRoutingTable = event.state().routingTable().index(shardId.getIndex());
                if (indexShardRoutingTable == null) {
                    return true;
                }
                ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.id()).primaryShard();
                if (shardRouting == null || !shardRouting.started() && !shardRouting.unassigned()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) {
            return false;
        }
        Set removedNodeIds = removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return snapshotsInProgress.entries().stream().anyMatch(snapshot -> {
            if (snapshot.state().completed()) {
                return false;
            }
            for (ObjectCursor shardStatus : snapshot.shards().values()) {
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)shardStatus.value;
                if (shardSnapshotStatus.state().completed() || !removedNodeIds.contains(shardSnapshotStatus.nodeId())) continue;
                return true;
            }
            return false;
        });
    }

    private void endSnapshot(SnapshotsInProgress.Entry entry, Metadata metadata, @Nullable RepositoryData repositoryData) {
        Snapshot snapshot = entry.snapshot();
        boolean newFinalization = this.endingSnapshots.add(snapshot);
        if (entry.repositoryStateId() == -2L) {
            LOGGER.debug("[{}] was aborted before starting", (Object)snapshot);
            this.removeFailedSnapshotFromClusterState(entry.snapshot(), new SnapshotException(snapshot, "Aborted on initialization"), repositoryData);
            return;
        }
        String repoName = entry.repository();
        if (this.tryEnterRepoLoop(repoName)) {
            if (repositoryData == null) {
                this.repositoriesService.repository(repoName).getRepositoryData().whenComplete((repoData, err) -> {
                    if (err == null) {
                        this.finalizeSnapshotEntry(entry, metadata, (RepositoryData)repoData);
                    } else {
                        this.clusterService.submitStateUpdateTask("fail repo tasks for [" + repoName + "]", new FailPendingRepoTasksTask(repoName, Exceptions.toException((Throwable)err)));
                    }
                });
            } else {
                this.finalizeSnapshotEntry(entry, metadata, repositoryData);
            }
        } else if (newFinalization) {
            this.repositoryOperations.addFinalization(entry, metadata);
        }
    }

    private boolean tryEnterRepoLoop(String repository) {
        return this.currentlyFinalizing.add(repository);
    }

    private void leaveRepoLoop(String repository) {
        boolean removed = this.currentlyFinalizing.remove(repository);
        assert (removed);
    }

    private void finalizeSnapshotEntry(SnapshotsInProgress.Entry entry, Metadata metadata, RepositoryData repositoryData) {
        assert (this.currentlyFinalizing.contains(entry.repository()));
        try {
            String failure = entry.failure();
            Snapshot snapshot = entry.snapshot();
            LOGGER.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)snapshot, (Object)entry.state(), (Object)failure);
            ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
            for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                SnapshotsInProgress.ShardState state2 = status.state();
                if (state2.failed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, status.reason()));
                    continue;
                }
                if (!state2.completed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId, "skipped"));
                    continue;
                }
                assert (state2 == SnapshotsInProgress.ShardState.SUCCESS);
            }
            ShardGenerations shardGenerations = SnapshotsService.buildGenerations(entry, metadata);
            String string = snapshot.getRepository();
            SnapshotInfo snapshotInfo = new SnapshotInfo(snapshot.getSnapshotId(), shardGenerations.indices().stream().map(IndexId::getName).toList(), entry.startTime(), failure, this.threadPool.absoluteTimeInMillis(), entry.partial() ? shardGenerations.totalShards() : entry.shards().size(), shardFailures, entry.includeGlobalState());
            Repository repository = this.repositoriesService.repository(snapshot.getRepository());
            repository.finalizeSnapshot(shardGenerations, repositoryData.getGenId(), SnapshotsService.metadataForSnapshot(entry, metadata), snapshotInfo, entry.version(), state -> SnapshotsService.stateWithoutSnapshot(state, snapshot), ActionListener.wrap(newRepoData -> {
                SnapshotsService.completeListenersIgnoringException(this.endAndGetListenersToResolve(snapshot), new Tuple(newRepoData, (Object)snapshotInfo));
                LOGGER.info("snapshot [{}] completed with state [{}]", (Object)snapshot, (Object)snapshotInfo.state());
                this.runNextQueuedOperation((RepositoryData)newRepoData, repositoryName, true);
            }, e -> this.handleFinalizationFailure((Exception)e, entry, repositoryData)));
        }
        catch (Exception e2) {
            assert (false) : new AssertionError((Object)e2);
            this.handleFinalizationFailure(e2, entry, repositoryData);
        }
    }

    private List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> endAndGetListenersToResolve(Snapshot snapshot) {
        List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> listenersToComplete = this.snapshotCompletionListeners.remove(snapshot);
        this.endingSnapshots.remove(snapshot);
        return listenersToComplete;
    }

    private void handleFinalizationFailure(Exception e, SnapshotsInProgress.Entry entry, RepositoryData repositoryData) {
        Snapshot snapshot = entry.snapshot();
        Class[] clazzes = new Class[]{NotMasterException.class, FailedToCommitClusterStateException.class};
        if (Exceptions.firstCause((Throwable)e, (Class[])clazzes) != null) {
            LOGGER.debug(() -> new ParameterizedMessage("[{}] failed to update cluster state during snapshot finalization", (Object)snapshot), (Throwable)e);
            this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to update cluster state during snapshot finalization", e));
            this.failAllListenersOnMasterFailOver(e);
        } else {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to finalize snapshot", (Object)snapshot), (Throwable)e);
            this.removeFailedSnapshotFromClusterState(snapshot, e, repositoryData);
        }
    }

    private void runNextQueuedOperation(RepositoryData repositoryData, String repository, boolean attemptDelete) {
        assert (this.currentlyFinalizing.contains(repository));
        Tuple<SnapshotsInProgress.Entry, Metadata> nextFinalization = this.repositoryOperations.pollFinalization(repository);
        if (nextFinalization == null) {
            if (attemptDelete) {
                this.runReadyDeletions(repositoryData, repository);
            } else {
                this.leaveRepoLoop(repository);
            }
        } else {
            LOGGER.trace("Moving on to finalizing next snapshot [{}]", nextFinalization);
            this.finalizeSnapshotEntry((SnapshotsInProgress.Entry)nextFinalization.v1(), (Metadata)nextFinalization.v2(), repositoryData);
        }
    }

    private void runReadyDeletions(final RepositoryData repositoryData, final String repository) {
        this.clusterService.submitStateUpdateTask("Run ready deletions", new ClusterStateUpdateTask(this){
            private SnapshotDeletionsInProgress.Entry deletionToRun;
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (SnapshotsService.readyDeletions(currentState).v1() == currentState) : "Deletes should have been set to ready by finished snapshot deletes and finalizations";
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                for (SnapshotDeletionsInProgress.Entry entry : deletionsInProgress.getEntries()) {
                    if (!entry.repository().equals(repository) || entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionToRun = entry;
                    break;
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.warn("Failed to run ready delete operations", (Throwable)e);
                this.this$0.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deletionToRun == null) {
                    this.this$0.runNextQueuedOperation(repositoryData, repository, false);
                } else {
                    this.this$0.deleteSnapshotsFromRepository(this.deletionToRun, repositoryData, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> readyDeletions(ClusterState currentState) {
        SnapshotDeletionsInProgress deletions = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        if (!deletions.hasDeletionsInProgress()) {
            return new Tuple((Object)currentState, Collections.emptyList());
        }
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)currentState.custom("snapshots");
        assert (snapshotsInProgress != null);
        HashSet<String> repositoriesSeen = new HashSet<String>();
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> readyDeletions = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        ArrayList<SnapshotDeletionsInProgress.Entry> newDeletes = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            String repo = entry.repository();
            if (repositoriesSeen.add(entry.repository()) && entry.state() == SnapshotDeletionsInProgress.State.WAITING && snapshotsInProgress.entries().stream().filter(se -> se.repository().equals(repo)).noneMatch(SnapshotsService::isWritingToRepository)) {
                changed = true;
                SnapshotDeletionsInProgress.Entry newEntry = entry.started();
                readyDeletions.add(newEntry);
                newDeletes.add(newEntry);
                continue;
            }
            newDeletes.add(entry);
        }
        return new Tuple((Object)(changed ? ClusterState.builder(currentState).putCustom("snapshot_deletions", SnapshotDeletionsInProgress.of(newDeletes)).build() : currentState), readyDeletions);
    }

    private static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot) {
        SnapshotsInProgress snapshots = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        ClusterState result = state;
        boolean changed = false;
        ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (entry.snapshot().equals(snapshot)) {
                changed = true;
                continue;
            }
            entries.add(entry);
        }
        if (changed) {
            result = ClusterState.builder(state).putCustom("snapshots", SnapshotsInProgress.of(Collections.unmodifiableList(entries))).build();
        }
        return (ClusterState)SnapshotsService.readyDeletions(result).v1();
    }

    private void removeFailedSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable RepositoryData repositoryData) {
        assert (failure != null) : "Failure must be supplied";
        this.clusterService.submitStateUpdateTask("remove snapshot metadata", new ClusterStateUpdateTask(this){
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(currentState, snapshot);
                return SnapshotsService.updateWithSnapshots(updatedState, null, SnapshotsService.deletionsWithoutSnapshots(updatedState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY), Collections.singletonList(snapshot.getSnapshotId()), snapshot.getRepository()));
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to remove snapshot metadata", (Object)snapshot), (Throwable)e);
                this.this$0.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e));
                this.this$0.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void onNoLongerMaster(String source) {
                failure.addSuppressed(new SnapshotException(snapshot, "no longer master"));
                this.this$0.failSnapshotCompletionListeners(snapshot, failure);
                this.this$0.failAllListenersOnMasterFailOver(new NotMasterException(source));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                this.this$0.failSnapshotCompletionListeners(snapshot, failure);
                if (repositoryData == null) {
                    this.this$0.leaveRepoLoop(snapshot.getRepository());
                } else {
                    this.this$0.runNextQueuedOperation(repositoryData, snapshot.getRepository(), true);
                }
            }
        });
    }

    @Nullable
    private static SnapshotDeletionsInProgress deletionsWithoutSnapshots(SnapshotDeletionsInProgress deletions, Collection<SnapshotId> snapshotIds, String repository) {
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(deletions.getEntries().size());
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (entry.repository().equals(repository)) {
                ArrayList<SnapshotId> updatedSnapshotIds = new ArrayList<SnapshotId>(entry.getSnapshots());
                if (updatedSnapshotIds.removeAll(snapshotIds)) {
                    changed = true;
                    updatedEntries.add(entry.withSnapshots(updatedSnapshotIds));
                    continue;
                }
                updatedEntries.add(entry);
                continue;
            }
            updatedEntries.add(entry);
        }
        return changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e) {
        SnapshotsService.failListenersIgnoringException(this.endAndGetListenersToResolve(snapshot), e);
        assert (this.repositoryOperations.assertNotQueued(snapshot));
    }

    public void deleteSnapshots(DeleteSnapshotRequest request, ActionListener<Void> listener) {
        final String[] snapshotNames = request.snapshots();
        final String repositoryName = request.repository();
        LOGGER.info(() -> new ParameterizedMessage("deleting snapshots [{}] from repository [{}]", (Object)Strings.arrayToCommaDelimitedString(snapshotNames), (Object)repositoryName));
        Repository repository = this.repositoriesService.repository(repositoryName);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(this, Priority.NORMAL, (RepositoryData)repositoryData, listener, request){
            private Snapshot runningSnapshot;
            private ClusterStateUpdateTask deleteFromRepoTask;
            private boolean abortedDuringInit;
            private List<SnapshotId> outstandingDeletes;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ DeleteSnapshotRequest val$request;
            final /* synthetic */ SnapshotsService this$0;
            {
                this.val$repositoryData = repositoryData;
                this.val$listener = actionListener;
                this.val$request = deleteSnapshotRequest;
                this.this$0 = this$0;
                super(priority);
                this.abortedDuringInit = false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                String failure;
                ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards;
                Version minNodeVersion = currentState.nodes().getMinNodeVersion();
                if (snapshotNames.length > 1 && minNodeVersion.before(MULTI_DELETE_VERSION)) {
                    throw new IllegalArgumentException("Deleting multiple snapshots in a single request is only supported in version [ " + String.valueOf(MULTI_DELETE_VERSION) + "] but cluster contained node of version [" + String.valueOf(currentState.nodes().getMinNodeVersion()) + "]");
                }
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                List<SnapshotsInProgress.Entry> snapshotEntries = SnapshotsService.findInProgressSnapshots(snapshots, snapshotNames, repositoryName);
                List<SnapshotId> snapshotIds = SnapshotsService.matchingSnapshotIds(snapshotEntries.stream().map(e -> e.snapshot().getSnapshotId()).toList(), this.val$repositoryData, snapshotNames, repositoryName);
                if (snapshotEntries.isEmpty() || minNodeVersion.onOrAfter(FULL_CONCURRENCY_VERSION)) {
                    this.deleteFromRepoTask = this.this$0.createDeleteStateUpdate(snapshotIds, repositoryName, this.val$repositoryData, Priority.NORMAL, this.val$listener);
                    return this.deleteFromRepoTask.execute(currentState);
                }
                assert (snapshotEntries.size() == 1) : "Expected just a single running snapshot but saw " + String.valueOf(snapshotEntries);
                SnapshotsInProgress.Entry snapshotEntry = snapshotEntries.get(0);
                this.runningSnapshot = snapshotEntry.snapshot();
                SnapshotsInProgress.State state = snapshotEntry.state();
                this.outstandingDeletes = new ArrayList<SnapshotId>(snapshotIds);
                if (state != SnapshotsInProgress.State.INIT) {
                    this.outstandingDeletes.add(this.runningSnapshot.getSnapshotId());
                }
                if (state == SnapshotsInProgress.State.INIT) {
                    shards = snapshotEntry.shards();
                    assert (shards.isEmpty());
                    failure = "Snapshot was aborted during initialization";
                    this.abortedDuringInit = true;
                } else if (state == SnapshotsInProgress.State.STARTED) {
                    SnapshotsInProgress.Entry abortedEntry = snapshotEntry.abort();
                    shards = abortedEntry.shards();
                    failure = abortedEntry.failure();
                } else {
                    boolean hasUncompletedShards = false;
                    for (ObjectCursor shardStatus : snapshotEntry.shards().values()) {
                        if (((SnapshotsInProgress.ShardSnapshotStatus)shardStatus.value).state().completed() || ((SnapshotsInProgress.ShardSnapshotStatus)shardStatus.value).nodeId() == null || currentState.nodes().get(((SnapshotsInProgress.ShardSnapshotStatus)shardStatus.value).nodeId()) == null) continue;
                        hasUncompletedShards = true;
                        break;
                    }
                    if (hasUncompletedShards) {
                        LOGGER.debug("trying to delete completed snapshot - should wait for shards to finalize on all nodes");
                        return currentState;
                    }
                    LOGGER.debug("trying to delete completed snapshot with no finalizing shards - can delete immediately");
                    shards = snapshotEntry.shards();
                    failure = snapshotEntry.failure();
                }
                SnapshotsInProgress newSnapshotsInProgress = SnapshotsInProgress.of(snapshots.entries().stream().filter(existing -> !this.abortedDuringInit || !existing.equals(snapshotEntry)).map(existing -> {
                    if (existing.equals(snapshotEntry)) {
                        return snapshotEntry.fail(shards, SnapshotsInProgress.State.ABORTED, failure);
                    }
                    return existing;
                }).toList());
                return ClusterState.builder(currentState).putCustom("snapshots", newSnapshotsInProgress).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deleteFromRepoTask != null) {
                    assert (this.outstandingDeletes == null) : "Shouldn't have outstanding deletes after already starting delete task";
                    this.deleteFromRepoTask.clusterStateProcessed(source, oldState, newState);
                    return;
                }
                if (this.abortedDuringInit) {
                    LOGGER.info("Successfully aborted snapshot [{}]", (Object)this.runningSnapshot);
                    if (this.outstandingDeletes.isEmpty()) {
                        this.val$listener.onResponse(null);
                    } else {
                        this.this$0.clusterService.submitStateUpdateTask("delete snapshot", this.this$0.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, this.val$repositoryData, Priority.IMMEDIATE, this.val$listener));
                    }
                    return;
                }
                LOGGER.trace("adding snapshot completion listener to wait for deleted snapshot to finish");
                this.this$0.addListener(this.runningSnapshot, ActionListener.wrap(result -> {
                    LOGGER.debug("deleted snapshot completed - deleting files");
                    this.this$0.clusterService.submitStateUpdateTask("delete snapshot", this.this$0.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, (RepositoryData)result.v1(), Priority.IMMEDIATE, this.val$listener));
                }, e -> {
                    Class[] clazzes = new Class[]{NotMasterException.class, FailedToCommitClusterStateException.class};
                    if (Exceptions.firstCause((Throwable)e, (Class[])clazzes) != null) {
                        LOGGER.warn("master failover before deleted snapshot could complete", (Throwable)e);
                        this.val$listener.onFailure((Exception)e);
                    } else {
                        LOGGER.warn("deleted snapshot failed", (Throwable)e);
                        this.val$listener.onFailure(new SnapshotMissingException(this.runningSnapshot.getRepository(), this.runningSnapshot.getSnapshotId(), (Throwable)e));
                    }
                }));
            }

            @Override
            public TimeValue timeout() {
                return this.val$request.masterNodeTimeout();
            }
        }, "delete snapshot", listener::onFailure);
    }

    private static List<SnapshotId> matchingSnapshotIds(List<SnapshotId> inProgress, RepositoryData repositoryData, String[] snapshotsOrPatterns, String repositoryName) {
        Map allSnapshotIds = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
        HashSet<SnapshotId> foundSnapshots = new HashSet<SnapshotId>(inProgress);
        for (String snapshotOrPattern : snapshotsOrPatterns) {
            if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                for (Map.Entry entry : allSnapshotIds.entrySet()) {
                    if (!Regex.simpleMatch(snapshotOrPattern, entry.getKey())) continue;
                    foundSnapshots.add((SnapshotId)entry.getValue());
                }
                continue;
            }
            SnapshotId foundId = (SnapshotId)allSnapshotIds.get(snapshotOrPattern);
            if (foundId == null) {
                if (!inProgress.stream().noneMatch(snapshotId -> snapshotId.getName().equals(snapshotOrPattern))) continue;
                throw new SnapshotMissingException(repositoryName, snapshotOrPattern);
            }
            foundSnapshots.add((SnapshotId)allSnapshotIds.get(snapshotOrPattern));
        }
        return Collections.unmodifiableList(new ArrayList<SnapshotId>(foundSnapshots));
    }

    private static List<SnapshotsInProgress.Entry> findInProgressSnapshots(SnapshotsInProgress snapshots, String[] snapshotNames, String repositoryName) {
        ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (!entry.repository().equals(repositoryName) || !Regex.simpleMatch(snapshotNames, entry.snapshot().getSnapshotId().getName())) continue;
            entries.add(entry);
        }
        return entries;
    }

    private ClusterStateUpdateTask createDeleteStateUpdate(final List<SnapshotId> snapshotIds, final String repoName, final RepositoryData repositoryData, Priority priority, final ActionListener<Void> listener) {
        if (snapshotIds.isEmpty()) {
            return new ClusterStateUpdateTask(this){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(null);
                }
            };
        }
        return new ClusterStateUpdateTask(this, priority){
            private SnapshotDeletionsInProgress.Entry newDelete;
            private boolean reusedExistingDelete;
            private final Collection<Snapshot> completedNoCleanup;
            private final Collection<SnapshotsInProgress.Entry> completedWithCleanup;
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
                super(priority);
                this.reusedExistingDelete = false;
                this.completedNoCleanup = new ArrayList<Snapshot>();
                this.completedWithCleanup = new ArrayList<SnapshotsInProgress.Entry>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotDeletionsInProgress.Entry replacedEntry;
                SnapshotsInProgress updatedSnapshots;
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                Version minNodeVersion = currentState.nodes().getMinNodeVersion();
                if (minNodeVersion.before(FULL_CONCURRENCY_VERSION) && deletionsInProgress.hasDeletionsInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete - another snapshot is currently being deleted in [" + String.valueOf(deletionsInProgress) + "]");
                }
                RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
                for (RestoreInProgress.Entry entry2 : restoreInProgress) {
                    if (!repoName.equals(entry2.snapshot().getRepository()) || !snapshotIds.contains(entry2.snapshot().getSnapshotId())) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshot during a restore in progress in [" + String.valueOf(restoreInProgress) + "]");
                }
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                HashSet<SnapshotId> snapshotIdsRequiringCleanup = new HashSet<SnapshotId>(snapshotIds);
                if (minNodeVersion.onOrAfter(FULL_CONCURRENCY_VERSION)) {
                    updatedSnapshots = SnapshotsInProgress.of(snapshots.entries().stream().map(existing -> {
                        if (existing.state() == SnapshotsInProgress.State.STARTED && snapshotIdsRequiringCleanup.contains(existing.snapshot().getSnapshotId())) {
                            SnapshotsInProgress.Entry abortedEntry = existing.abort();
                            if (abortedEntry == null) {
                                Snapshot existingNotYetStartedSnapshot = existing.snapshot();
                                if (this.this$0.endingSnapshots.add(existingNotYetStartedSnapshot)) {
                                    this.completedNoCleanup.add(existingNotYetStartedSnapshot);
                                }
                                snapshotIdsRequiringCleanup.remove(existingNotYetStartedSnapshot.getSnapshotId());
                            } else if (abortedEntry.state().completed()) {
                                this.completedWithCleanup.add(abortedEntry);
                            }
                            return abortedEntry;
                        }
                        return existing;
                    }).filter(Objects::nonNull).collect(Collectors.toList()));
                    if (snapshotIdsRequiringCleanup.isEmpty()) {
                        return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, null);
                    }
                } else {
                    if (!snapshots.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(repoName, snapshotIds.toString(), "another snapshot is currently running cannot delete");
                    }
                    updatedSnapshots = snapshots;
                }
                if ((replacedEntry = (SnapshotDeletionsInProgress.Entry)deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.WAITING).findFirst().orElse(null)) == null) {
                    Optional<SnapshotDeletionsInProgress.Entry> foundDuplicate = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED && entry.getSnapshots().containsAll(snapshotIds)).findFirst();
                    if (foundDuplicate.isPresent()) {
                        this.newDelete = foundDuplicate.get();
                        this.reusedExistingDelete = true;
                        return currentState;
                    }
                    List<SnapshotId> toDelete = Collections.unmodifiableList(new ArrayList<SnapshotId>(snapshotIdsRequiringCleanup));
                    this.this$0.ensureBelowConcurrencyLimit(repoName, toDelete.get(0).getName(), snapshots, deletionsInProgress);
                    boolean noneWritingToRepository = updatedSnapshots.entries().stream().filter(entry -> repoName.equals(entry.repository())).noneMatch(SnapshotsService::isWritingToRepository);
                    boolean noDeletionsStarted = deletionsInProgress.getEntries().stream().filter(entry -> repoName.equals(entry.repository())).noneMatch(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED);
                    this.newDelete = new SnapshotDeletionsInProgress.Entry(toDelete, repoName, this.this$0.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), noneWritingToRepository && noDeletionsStarted ? SnapshotDeletionsInProgress.State.STARTED : SnapshotDeletionsInProgress.State.WAITING);
                } else {
                    this.newDelete = replacedEntry.withAddedSnapshots(snapshotIdsRequiringCleanup);
                }
                return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, (replacedEntry == null ? deletionsInProgress : deletionsInProgress.withRemovedEntry(replacedEntry.uuid())).withAddedEntry(this.newDelete));
            }

            @Override
            public void onFailure(String source, Exception e) {
                this.this$0.endingSnapshots.removeAll(this.completedNoCleanup);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (!this.completedNoCleanup.isEmpty()) {
                    LOGGER.info("snapshots {} aborted", this.completedNoCleanup);
                }
                for (Snapshot snapshot : this.completedNoCleanup) {
                    this.this$0.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Snapshot was aborted by deletion"));
                }
                if (this.newDelete == null) {
                    listener.onResponse(null);
                } else {
                    this.this$0.addDeleteListener(this.newDelete.uuid(), listener);
                    if (this.reusedExistingDelete) {
                        return;
                    }
                    if (this.newDelete.state() == SnapshotDeletionsInProgress.State.STARTED) {
                        if (this.this$0.tryEnterRepoLoop(repoName)) {
                            this.this$0.deleteSnapshotsFromRepository(this.newDelete, repositoryData, newState.nodes().getMinNodeVersion());
                        } else {
                            LOGGER.trace("Delete [{}] could not execute directly and was queued", (Object)this.newDelete);
                        }
                    } else {
                        for (SnapshotsInProgress.Entry completedSnapshot : this.completedWithCleanup) {
                            this.this$0.endSnapshot(completedSnapshot, newState.metadata(), repositoryData);
                        }
                    }
                }
            }
        };
    }

    private static boolean isWritingToRepository(SnapshotsInProgress.Entry entry) {
        if (entry.state().completed()) {
            return true;
        }
        for (ObjectCursor value : entry.shards().values()) {
            if (!((SnapshotsInProgress.ShardSnapshotStatus)value.value).isActive()) continue;
            return true;
        }
        return false;
    }

    private void addDeleteListener(String deleteUUID, ActionListener<Void> listener) {
        this.snapshotDeletionListeners.computeIfAbsent(deleteUUID, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public Version minCompatibleVersion(Version minNodeVersion, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        Version minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds) {
            if (excluded != null && excluded.contains(snapshotId)) continue;
            Version known = repositoryData.getVersion(snapshotId);
            if (known == null) {
                assert (repositoryData.shardGenerations().totalShards() == 0) : "Saw shard generations [" + String.valueOf(repositoryData.shardGenerations()) + "] but did not have versions tracked for snapshot [" + String.valueOf(snapshotId) + "]";
                return OLD_SNAPSHOT_FORMAT;
            }
            minCompatVersion = minCompatVersion.before(known) ? minCompatVersion : known;
        }
        return minCompatVersion;
    }

    public static boolean useShardGenerations(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean useIndexGenerations(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(INDEX_GEN_IN_REPO_DATA_VERSION);
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final Version minNodeVersion) {
        final long expectedRepoGen = deleteEntry.repositoryStateId();
        this.repositoriesService.getRepositoryData(deleteEntry.repository()).whenComplete(new ActionListener<RepositoryData>(){
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(RepositoryData repositoryData) {
                assert (repositoryData.getGenId() == expectedRepoGen) : "Repository generation should not change as long as a ready delete is found in the cluster state but found [" + expectedRepoGen + "] in cluster state and [" + repositoryData.getGenId() + "] in the repository";
                this.this$0.deleteSnapshotsFromRepository(deleteEntry, repositoryData, minNodeVersion);
            }

            @Override
            public void onFailure(Exception e) {
                this.this$0.clusterService.submitStateUpdateTask("fail repo tasks for [" + deleteEntry.repository() + "]", this.this$0.new FailPendingRepoTasksTask(deleteEntry.repository(), e));
            }
        });
    }

    private void deleteSnapshotsFromRepository(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData, Version minNodeVersion) {
        if (this.repositoryOperations.startDeletion(deleteEntry.uuid())) {
            assert (this.currentlyFinalizing.contains(deleteEntry.repository()));
            List<SnapshotId> snapshotIds = deleteEntry.getSnapshots();
            assert (deleteEntry.state() == SnapshotDeletionsInProgress.State.STARTED) : "incorrect state for entry [" + String.valueOf(deleteEntry) + "]";
            this.repositoriesService.repository(deleteEntry.repository()).deleteSnapshots(snapshotIds, repositoryData.getGenId(), this.minCompatibleVersion(minNodeVersion, repositoryData, snapshotIds), ActionListener.wrap(updatedRepoData -> {
                LOGGER.info("snapshots {} deleted", (Object)snapshotIds);
                this.removeSnapshotDeletionFromClusterState(deleteEntry, null, (RepositoryData)updatedRepoData);
            }, ex -> this.removeSnapshotDeletionFromClusterState(deleteEntry, (Exception)ex, repositoryData)));
        }
    }

    private void removeSnapshotDeletionFromClusterState(SnapshotDeletionsInProgress.Entry deleteEntry, final @Nullable Exception failure, final RepositoryData repositoryData) {
        RemoveSnapshotDeletionAndContinueTask clusterStateUpdateTask = failure == null ? new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

            @Override
            protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
                SnapshotDeletionsInProgress updatedDeletions = SnapshotsService.deletionsWithoutSnapshots(deletions, this.deleteEntry.getSnapshots(), this.deleteEntry.repository());
                return updatedDeletions == null ? deletions : updatedDeletions;
            }

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                assert (repositoryData.getSnapshotIds().stream().noneMatch(this.deleteEntry.getSnapshots()::contains)) : "Repository data contained snapshot ids " + String.valueOf(repositoryData.getSnapshotIds()) + " that should should been deleted by [" + String.valueOf(this.deleteEntry) + "]";
                SnapshotsService.completeListenersIgnoringException(deleteListeners, null);
            }
        } : new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                SnapshotsService.failListenersIgnoringException(deleteListeners, failure);
            }
        };
        this.clusterService.submitStateUpdateTask("remove snapshot deletion metadata", clusterStateUpdateTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllListenersOnMasterFailOver(Exception e) {
        LOGGER.debug("Failing all snapshot operation listeners because this node is not master any longer", (Throwable)e);
        Set<String> set = this.currentlyFinalizing;
        synchronized (set) {
            Class[] clazzes = new Class[]{NotMasterException.class, FailedToCommitClusterStateException.class};
            if (Exceptions.firstCause((Throwable)e, (Class[])clazzes) != null) {
                this.repositoryOperations.clear();
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"));
                }
                RepositoryException wrapped = new RepositoryException("_all", "Failed to update cluster state during repository operation", e);
                Iterator<List<ActionListener<Void>>> iterator = this.snapshotDeletionListeners.values().iterator();
                while (iterator.hasNext()) {
                    List listeners = iterator.next();
                    iterator.remove();
                    SnapshotsService.failListenersIgnoringException(listeners, wrapped);
                }
                assert (this.snapshotDeletionListeners.isEmpty()) : "No new listeners should have been added but saw " + String.valueOf(this.snapshotDeletionListeners);
            } else {
                assert (false) : new AssertionError("Modifying snapshot state should only ever fail because we failed to publish new state", e);
                LOGGER.error("Unexpected failure during cluster state update", (Throwable)e);
            }
            this.currentlyFinalizing.clear();
        }
    }

    public static ClusterState updateWithSnapshots(ClusterState state, @Nullable SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress snapshotDeletionsInProgress) {
        if (snapshotsInProgress == null && snapshotDeletionsInProgress == null) {
            return state;
        }
        ClusterState.Builder builder = ClusterState.builder(state);
        if (snapshotsInProgress != null) {
            builder.putCustom("snapshots", snapshotsInProgress);
        }
        if (snapshotDeletionsInProgress != null) {
            builder.putCustom("snapshot_deletions", snapshotDeletionsInProgress);
        }
        return builder.build();
    }

    private static <T> void failListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, Exception failure) {
        if (listeners != null) {
            try {
                ActionListener.onFailure(listeners, failure);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                LOGGER.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static <T> void completeListenersIgnoringException(@Nullable List<ActionListener<T>> listeners, T result) {
        if (listeners != null) {
            try {
                ActionListener.onResponse(listeners, result);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                LOGGER.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress deletionsInProgress, Metadata metadata, RoutingTable routingTable, List<IndexId> indices, boolean useShardGenerations, RepositoryData repositoryData, String repoName) {
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forRepo(repoName, snapshotsInProgress.entries());
        boolean readyToExecute = deletionsInProgress == null || deletionsInProgress.getEntries().stream().noneMatch(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED);
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = metadata.getIndexByName(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                continue;
            }
            String indexUUID = indexMetadata.getIndexUUID();
            IndexRoutingTable indexRoutingTable = routingTable.index(indexUUID);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                String shardRepoGeneration;
                ShardId shardId = indexRoutingTable.shard(i).shardId();
                if (useShardGenerations) {
                    String inFlightGeneration = inFlightShardStates.generationForShard(index, shardId.id(), shardGenerations);
                    if (inFlightGeneration == null && isNewIndex) {
                        assert (shardGenerations.getShardGen(index, shardId.id()) == null) : "Found shard generation for new index [" + String.valueOf(index) + "]";
                        shardRepoGeneration = "_new";
                    } else {
                        shardRepoGeneration = inFlightGeneration;
                    }
                } else {
                    shardRepoGeneration = null;
                }
                ShardRouting primary = indexRoutingTable.shard(i).primaryShard();
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = !readyToExecute || inFlightShardStates.isActive(indexName, i) ? SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED : (primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "primary shard is not allocated", shardRepoGeneration) : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, "primary shard hasn't been started yet", shardRepoGeneration) : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration))));
                builder.put(shardId, shardSnapshotStatus);
            }
        }
        return builder.build();
    }

    public static Set<Index> snapshottingIndices(ClusterState currentState, Collection<Index> indicesToCheck) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
        if (snapshots == null) {
            return Set.of();
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
            if (entry.partial()) continue;
            for (IndexId index : entry.indices()) {
                IndexMetadata indexMetadata = currentState.metadata().index(index.getName());
                if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                indices.add(indexMetadata.getIndex());
            }
        }
        return indices;
    }

    private void addListener(Snapshot snapshot, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(listener);
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    public boolean assertAllListenersResolved() {
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + String.valueOf(this.endingSnapshots) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + String.valueOf(this.snapshotCompletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.currentlyFinalizing.isEmpty()) : "Found leaked finalizations " + String.valueOf(this.currentlyFinalizing) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotDeletionListeners.isEmpty()) : "Found leaked snapshot delete listeners " + String.valueOf(this.snapshotDeletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.repositoryOperations.isEmpty()) : "Found leaked snapshots to finalize " + String.valueOf(this.repositoryOperations) + " on [" + String.valueOf(localNode) + "]";
        return true;
    }

    private void innerUpdateSnapshotState(final UpdateIndexShardSnapshotStatusRequest request, final ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
        LOGGER.trace("received updated snapshot restore state [{}]", (Object)request);
        this.clusterService.submitStateUpdateTask("update snapshot state", request, ClusterStateTaskConfig.build(Priority.NORMAL), this.snapshotStateExecutor, new ClusterStateTaskListener(){
            final /* synthetic */ SnapshotsService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    listener.onResponse(new UpdateIndexShardSnapshotStatusResponse());
                }
                finally {
                    SnapshotsInProgress snapshotsInProgress;
                    SnapshotsInProgress.Entry updatedEntry;
                    if (!this.this$0.endingSnapshots.contains(request.snapshot()) && (updatedEntry = (snapshotsInProgress = (SnapshotsInProgress)newState.custom("snapshots")).snapshot(request.snapshot())) != null && updatedEntry.state().completed()) {
                        this.this$0.endSnapshot(updatedEntry, newState.metadata(), null);
                    }
                }
            }
        });
    }

    private static class SnapshotStateExecutor
    implements ClusterStateTaskExecutor<UpdateIndexShardSnapshotStatusRequest> {
        private SnapshotStateExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<UpdateIndexShardSnapshotStatusRequest> execute(ClusterState currentState, List<UpdateIndexShardSnapshotStatusRequest> tasks) {
            int changedCount = 0;
            int startedCount = 0;
            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
            ArrayList<UpdateIndexShardSnapshotStatusRequest> unconsumedTasks = new ArrayList<UpdateIndexShardSnapshotStatusRequest>(tasks);
            HashSet<UpdateIndexShardSnapshotStatusRequest> executedTasks = new HashSet<UpdateIndexShardSnapshotStatusRequest>();
            for (SnapshotsInProgress.Entry entry : currentState.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
                if (entry.state().completed()) {
                    entries.add(entry);
                    continue;
                }
                ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = null;
                Iterator iterator = unconsumedTasks.iterator();
                while (iterator.hasNext()) {
                    SnapshotsInProgress.ShardSnapshotStatus existingStatus;
                    UpdateIndexShardSnapshotStatusRequest updateSnapshotState = (UpdateIndexShardSnapshotStatusRequest)iterator.next();
                    Snapshot updatedSnapshot = updateSnapshotState.snapshot();
                    String updatedRepository = updatedSnapshot.getRepository();
                    if (!entry.repository().equals(updatedRepository)) continue;
                    ShardId finishedShardId = updateSnapshotState.shardId();
                    if (entry.snapshot().getSnapshotId().equals(updatedSnapshot.getSnapshotId())) {
                        SnapshotsInProgress.ShardSnapshotStatus existing = entry.shards().get(finishedShardId);
                        if (existing == null) {
                            LOGGER.warn("Received shard snapshot status update [{}] but this shard is not tracked in [{}]", (Object)updateSnapshotState, (Object)entry);
                            assert (false) : "This should never happen, data nodes should only send updates for expected shards";
                            continue;
                        }
                        if (existing.state().completed()) {
                            iterator.remove();
                            continue;
                        }
                        LOGGER.trace("[{}] Updating shard [{}] with status [{}]", (Object)updatedSnapshot, (Object)finishedShardId, (Object)updateSnapshotState.status().state());
                        if (shards == null) {
                            shards = ImmutableOpenMap.builder(entry.shards());
                        }
                        shards.put(finishedShardId, updateSnapshotState.status());
                        executedTasks.add(updateSnapshotState);
                        ++changedCount;
                        continue;
                    }
                    if (!executedTasks.contains(updateSnapshotState) || (existingStatus = entry.shards().get(finishedShardId)) == null || existingStatus.state() != SnapshotsInProgress.ShardState.QUEUED) continue;
                    if (shards == null) {
                        shards = ImmutableOpenMap.builder(entry.shards());
                    }
                    SnapshotsInProgress.ShardSnapshotStatus finishedStatus = updateSnapshotState.status();
                    LOGGER.trace("Starting [{}] on [{}] with generation [{}]", (Object)finishedShardId, (Object)finishedStatus.nodeId(), (Object)finishedStatus.generation());
                    shards.put(finishedShardId, new SnapshotsInProgress.ShardSnapshotStatus(finishedStatus.nodeId(), finishedStatus.generation()));
                    iterator.remove();
                    ++startedCount;
                }
                if (shards == null) {
                    entries.add(entry);
                    continue;
                }
                entries.add(entry.withShardStates(shards.build()));
            }
            if (changedCount > 0) {
                LOGGER.trace("changed cluster state triggered by [{}] snapshot state updates and resulted in starting [{}] shard snapshots", (Object)changedCount, (Object)startedCount);
                return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(ClusterState.builder(currentState).putCustom("snapshots", SnapshotsInProgress.of(entries)).build());
            }
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
    }

    private static final class OngoingRepositoryOperations {
        private final Map<String, Deque<SnapshotsInProgress.Entry>> snapshotsToFinalize = new HashMap<String, Deque<SnapshotsInProgress.Entry>>();
        private final Set<String> runningDeletions = Collections.synchronizedSet(new HashSet());
        @Nullable
        private Metadata latestKnownMetaData;

        private OngoingRepositoryOperations() {
        }

        @Nullable
        synchronized Tuple<SnapshotsInProgress.Entry, Metadata> pollFinalization(String repository) {
            this.assertConsistent();
            Deque<SnapshotsInProgress.Entry> queued = this.snapshotsToFinalize.get(repository);
            if (queued == null) {
                return null;
            }
            SnapshotsInProgress.Entry nextEntry = queued.pollFirst();
            assert (nextEntry != null);
            Tuple res = new Tuple((Object)nextEntry, (Object)this.latestKnownMetaData);
            if (queued.isEmpty()) {
                this.snapshotsToFinalize.remove(repository);
            }
            if (this.snapshotsToFinalize.isEmpty()) {
                this.latestKnownMetaData = null;
            }
            assert (this.assertConsistent());
            return res;
        }

        boolean startDeletion(String deleteUUID) {
            return this.runningDeletions.add(deleteUUID);
        }

        void finishDeletion(String deleteUUID) {
            this.runningDeletions.remove(deleteUUID);
        }

        synchronized void addFinalization(SnapshotsInProgress.Entry entry, Metadata metadata) {
            this.snapshotsToFinalize.computeIfAbsent(entry.repository(), k -> new LinkedList()).add(entry);
            this.latestKnownMetaData = metadata;
            this.assertConsistent();
        }

        synchronized void clear() {
            this.snapshotsToFinalize.clear();
            this.runningDeletions.clear();
            this.latestKnownMetaData = null;
        }

        synchronized boolean isEmpty() {
            return this.snapshotsToFinalize.isEmpty();
        }

        synchronized boolean assertNotQueued(Snapshot snapshot) {
            assert (((Deque)this.snapshotsToFinalize.getOrDefault(snapshot.getRepository(), new LinkedList())).stream().noneMatch(entry -> entry.snapshot().equals(snapshot))) : "Snapshot [" + String.valueOf(snapshot) + "] is still in finalization queue";
            return true;
        }

        synchronized boolean assertConsistent() {
            assert (this.latestKnownMetaData == null && this.snapshotsToFinalize.isEmpty() || this.latestKnownMetaData != null && !this.snapshotsToFinalize.isEmpty()) : "Should not hold on to metadata if there are no more queued snapshots";
            assert (this.snapshotsToFinalize.values().stream().noneMatch(Collection::isEmpty)) : "Found empty queue in " + String.valueOf(this.snapshotsToFinalize);
            return true;
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, UpdateIndexShardSnapshotStatusResponse> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
            super(SnapshotsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, false, transportService, clusterService, threadPool, UpdateIndexShardSnapshotStatusRequest::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected UpdateIndexShardSnapshotStatusResponse read(StreamInput in) throws IOException {
            return new UpdateIndexShardSnapshotStatusResponse();
        }

        @Override
        protected void masterOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) throws Exception {
            SnapshotsService.this.innerUpdateSnapshotState(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    private final class FailPendingRepoTasksTask
    extends ClusterStateUpdateTask {
        private final List<Snapshot> snapshotsToFail = new ArrayList<Snapshot>();
        private final List<String> deletionsToFail = new ArrayList<String>();
        private final Exception failure;
        private final String repository;

        FailPendingRepoTasksTask(String repository, Exception failure) {
            this.repository = repository;
            this.failure = failure;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            boolean changed = false;
            List<SnapshotDeletionsInProgress.Entry> remainingEntries = deletionsInProgress.getEntries();
            ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(remainingEntries.size());
            for (SnapshotDeletionsInProgress.Entry entry : remainingEntries) {
                if (entry.repository().equals(this.repository)) {
                    changed = true;
                    this.deletionsToFail.add(entry.uuid());
                    continue;
                }
                updatedEntries.add(entry);
            }
            SnapshotDeletionsInProgress updatedDeletions = changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            boolean changedSnapshots = false;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                if (entry.repository().equals(this.repository)) {
                    this.snapshotsToFail.add(entry.snapshot());
                    changedSnapshots = true;
                    continue;
                }
                snapshotEntries.add(entry);
            }
            SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? SnapshotsInProgress.of(snapshotEntries) : null;
            return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshotsInProgress, updatedDeletions);
        }

        @Override
        public void onFailure(String source, Exception e) {
            LOGGER.info(() -> new ParameterizedMessage("Failed to remove all snapshot tasks for repo [{}] from cluster state", (Object)this.repository), (Throwable)e);
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            LOGGER.warn(() -> new ParameterizedMessage("Removed all snapshot tasks for repository [{}] from cluster state, now failing listeners", (Object)this.repository), (Throwable)this.failure);
            Set<String> set = SnapshotsService.this.currentlyFinalizing;
            synchronized (set) {
                Tuple<SnapshotsInProgress.Entry, Metadata> finalization;
                while ((finalization = SnapshotsService.this.repositoryOperations.pollFinalization(this.repository)) != null) {
                    assert (this.snapshotsToFail.contains(((SnapshotsInProgress.Entry)finalization.v1()).snapshot())) : "[" + String.valueOf(finalization.v1()) + "] not found in snapshots to fail " + String.valueOf(this.snapshotsToFail);
                }
                SnapshotsService.this.leaveRepoLoop(this.repository);
                for (Snapshot snapshot : this.snapshotsToFail) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, this.failure);
                }
                for (String delete : this.deletionsToFail) {
                    SnapshotsService.failListenersIgnoringException(SnapshotsService.this.snapshotDeletionListeners.remove(delete), this.failure);
                    SnapshotsService.this.repositoryOperations.finishDeletion(delete);
                }
            }
        }
    }

    private abstract class RemoveSnapshotDeletionAndContinueTask
    extends ClusterStateUpdateTask {
        protected final List<SnapshotsInProgress.Entry> newFinalizations = new ArrayList<SnapshotsInProgress.Entry>();
        private List<SnapshotDeletionsInProgress.Entry> readyDeletions = Collections.emptyList();
        protected final SnapshotDeletionsInProgress.Entry deleteEntry;
        private final RepositoryData repositoryData;

        RemoveSnapshotDeletionAndContinueTask(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData) {
            this.deleteEntry = deleteEntry;
            this.repositoryData = repositoryData;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
            assert (deletions != null) : "We only run this if there were deletions in the cluster state before";
            SnapshotDeletionsInProgress updatedDeletions = deletions.withRemovedEntry(this.deleteEntry.uuid());
            if (updatedDeletions == deletions) {
                return currentState;
            }
            SnapshotDeletionsInProgress newDeletions = this.filterDeletions(updatedDeletions);
            Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> res = SnapshotsService.readyDeletions(SnapshotsService.updateWithSnapshots(currentState, this.updatedSnapshotsInProgress(currentState, newDeletions), newDeletions));
            this.readyDeletions = (List)res.v2();
            return (ClusterState)res.v1();
        }

        @Override
        public void onFailure(String source, Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("{} failed to remove snapshot deletion metadata", (Object)this.deleteEntry), (Throwable)e);
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
            return deletions;
        }

        @Override
        public final void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            List<ActionListener<Void>> deleteListeners = SnapshotsService.this.snapshotDeletionListeners.remove(this.deleteEntry.uuid());
            this.handleListeners(deleteListeners);
            if (this.newFinalizations.isEmpty()) {
                if (this.readyDeletions.isEmpty()) {
                    SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                } else {
                    for (SnapshotDeletionsInProgress.Entry readyDeletion : this.readyDeletions) {
                        SnapshotsService.this.deleteSnapshotsFromRepository(readyDeletion, this.repositoryData, newState.nodes().getMinNodeVersion());
                    }
                }
            } else {
                SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                assert (this.readyDeletions.stream().noneMatch(entry -> entry.repository().equals(this.deleteEntry.repository()))) : "New finalizations " + String.valueOf(this.newFinalizations) + " added even though deletes " + String.valueOf(this.readyDeletions) + " are ready";
                for (SnapshotsInProgress.Entry entry2 : this.newFinalizations) {
                    SnapshotsService.this.endSnapshot(entry2, newState.metadata(), this.repositoryData);
                }
            }
        }

        protected abstract void handleListeners(@Nullable List<ActionListener<Void>> var1);

        @Nullable
        private SnapshotsInProgress updatedSnapshotsInProgress(ClusterState currentState, SnapshotDeletionsInProgress updatedDeletions) {
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            HashSet<ShardId> reassignedShardIds = new HashSet<ShardId>();
            boolean changed = false;
            String repoName = this.deleteEntry.repository();
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardAssignments = null;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                if (entry.repository().equals(repoName)) {
                    if (!entry.state().completed()) {
                        ArrayList<ShardId> canBeUpdated = new ArrayList<ShardId>();
                        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                            if (!((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(objectObjectCursor.key)) continue;
                            canBeUpdated.add((ShardId)objectObjectCursor.key);
                        }
                        if (canBeUpdated.isEmpty()) {
                            snapshotEntries.add(entry);
                            continue;
                        }
                        if (shardAssignments == null) {
                            shardAssignments = SnapshotsService.shards(snapshotsInProgress, updatedDeletions, currentState.metadata(), currentState.routingTable(), entry.indices(), entry.version().onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION), this.repositoryData, repoName);
                        }
                        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry.shards());
                        for (ShardId shardId : canBeUpdated) {
                            SnapshotsInProgress.ShardSnapshotStatus updated = shardAssignments.get(shardId);
                            if (updated == null) {
                                assert (!currentState.routingTable().hasIndex(shardId.getIndex())) : "Missing assignment for [" + String.valueOf(shardId) + "]";
                                updatedAssignmentsBuilder.put(shardId, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                                continue;
                            }
                            boolean added = reassignedShardIds.add(shardId);
                            assert (added);
                            updatedAssignmentsBuilder.put(shardId, updated);
                        }
                        snapshotEntries.add(entry.withStartedShards(updatedAssignmentsBuilder.build()));
                        changed = true;
                        continue;
                    }
                    this.newFinalizations.add(entry);
                    snapshotEntries.add(entry);
                    continue;
                }
                snapshotEntries.add(entry);
            }
            return changed ? SnapshotsInProgress.of(snapshotEntries) : null;
        }
    }
}

