/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.PriorityRunnable;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public final class PrioFixedExecutorBuilder
extends FixedExecutorBuilder {
    public PrioFixedExecutorBuilder(Settings settings, String name, int size, int queueSize) {
        super(settings, name, size, queueSize);
    }

    @Override
    ThreadPool.ExecutorHolder build(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int size = (Integer)this.sizeSetting.get(settings);
        int queueSize = (Integer)this.queueSizeSetting.get(settings);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(EsExecutors.threadName(nodeName, this.name()));
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(this, nodeName + "/" + this.name(), size, size, 0L, TimeUnit.MILLISECONDS, new SizeBlockingQueue(new PriorityBlockingQueue(queueSize), queueSize), threadFactory, new EsAbortPolicy()){

            @Override
            protected Runnable wrapRunnable(Runnable command) {
                if (command instanceof PrioritizedRunnable) {
                    return command;
                }
                return PriorityRunnable.of(Priority.NORMAL, "implicit", command);
            }
        };
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.FIXED, size, size, null, new SizeValue(queueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }
}

