/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;

public class ThreadPoolStats
extends AbstractList<Stats>
implements Writeable {
    private final List<Stats> stats;

    public ThreadPoolStats(List<Stats> stats) {
        Collections.sort(stats);
        this.stats = stats;
    }

    public ThreadPoolStats(StreamInput in) throws IOException {
        this.stats = in.readList(Stats::of);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.stats);
    }

    @Override
    public Stats get(int index) {
        return this.stats.get(index);
    }

    @Override
    @NotNull
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    @Override
    public int size() {
        return this.stats.size();
    }

    public record Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed) implements Writeable,
    Comparable<Stats>
    {
        public static Stats of(StreamInput in) throws IOException {
            String name = in.readString();
            int threads = in.readInt();
            int queue = in.readInt();
            int active = in.readInt();
            long rejected = in.readLong();
            int largest = in.readInt();
            long completed = in.readLong();
            return new Stats(name, threads, queue, active, rejected, largest, completed);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
            out.writeLong(this.rejected);
            out.writeInt(this.largest);
            out.writeLong(this.completed);
        }

        @Override
        public int compareTo(Stats other) {
            if (this.name() == null && other.name() == null) {
                return 0;
            }
            if (this.name() != null && other.name() == null) {
                return 1;
            }
            if (this.name() == null) {
                return -1;
            }
            int compare = this.name().compareTo(other.name());
            if (compare == 0) {
                compare = Integer.compare(this.threads(), other.threads());
            }
            return compare;
        }
    }
}

