/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.Transports;

public class ClusterConnectionManager
implements ConnectionManager {
    private static final Logger LOGGER = LogManager.getLogger(ClusterConnectionManager.class);
    private final ConcurrentMap<DiscoveryNode, Transport.Connection> connectedNodes = new ConcurrentHashMap<DiscoveryNode, Transport.Connection>();
    private final ConcurrentMap<DiscoveryNode, CompletableFuture<Void>> pendingConnections = new ConcurrentHashMap<DiscoveryNode, CompletableFuture<Void>>();
    private final AbstractRefCounted connectingRefCounter = new AbstractRefCounted("connection manager"){

        @Override
        protected void closeInternal() {
            Iterator iterator = ClusterConnectionManager.this.connectedNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)next.getValue()});
                }
                finally {
                    iterator.remove();
                }
            }
            ClusterConnectionManager.this.closeLatch.countDown();
        }
    };
    private final Transport transport;
    private final ConnectionProfile defaultProfile;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final ConnectionManager.DelegatingNodeConnectionListener connectionListener = new ConnectionManager.DelegatingNodeConnectionListener();

    public ClusterConnectionManager(Settings settings, Transport transport) {
        this(ConnectionProfile.buildDefaultConnectionProfile(settings), transport);
    }

    public ClusterConnectionManager(ConnectionProfile connectionProfile, Transport transport) {
        this.transport = transport;
        this.defaultProfile = connectionProfile;
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.connectionListener.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.connectionListener.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        this.internalOpenConnection(node, resolvedProfile, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        if (node == null) {
            listener.onFailure(new ConnectTransportException(null, "can't connect to a null node"));
            return;
        }
        if (!this.connectingRefCounter.tryIncRef()) {
            listener.onFailure((Exception)((Object)new AlreadyClosedException("ConnectionManager is closed")));
            return;
        }
        if (this.connectedNodes.containsKey(node)) {
            this.connectingRefCounter.decRef();
            listener.onResponse(null);
            return;
        }
        CompletableFuture currentListener = new CompletableFuture();
        CompletableFuture existingListener = this.pendingConnections.putIfAbsent(node, currentListener);
        if (existingListener != null) {
            try {
                existingListener.whenCompleteAsync(listener, EsExecutors.directExecutor());
            }
            finally {
                this.connectingRefCounter.decRef();
            }
            return;
        }
        currentListener.whenCompleteAsync(listener, EsExecutors.directExecutor());
        RunOnce releaseOnce = new RunOnce(this.connectingRefCounter::decRef);
        this.internalOpenConnection(node, this.defaultProfile, ActionListener.wrap(conn -> connectionValidator.validate((Transport.Connection)conn, this.defaultProfile, ActionListener.wrap(ignored -> {
            block9: {
                assert (Transports.assertNotTransportThread("connection validator success"));
                try {
                    if (this.connectedNodes.putIfAbsent(node, (Transport.Connection)conn) != null) {
                        LOGGER.debug("existing connection to node [{}], closing new redundant connection", (Object)node);
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{conn});
                        break block9;
                    }
                    LOGGER.debug("connected to node [{}]", (Object)node);
                    try {
                        this.connectionListener.onNodeConnected(node, (Transport.Connection)conn);
                    }
                    finally {
                        Transport.Connection finalConnection = conn;
                        conn.addCloseListener(ActionListener.wrap(() -> {
                            LOGGER.trace("unregistering {} after connection close and marking as disconnected", (Object)node);
                            this.connectedNodes.remove(node, finalConnection);
                            this.connectionListener.onNodeDisconnected(node, (Transport.Connection)conn);
                        }));
                    }
                }
                finally {
                    CompletableFuture future = (CompletableFuture)this.pendingConnections.remove(node);
                    assert (future == currentListener) : "Listener in pending map is different than the expected listener";
                    releaseOnce.run();
                    future.complete(null);
                }
            }
        }, e -> {
            assert (Transports.assertNotTransportThread("connection validator failure"));
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{conn});
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        })), e -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection failure"));
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        }));
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
        if (connection == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return connection;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        Transport.Connection nodeChannels = (Transport.Connection)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            nodeChannels.close();
        }
    }

    @Override
    public int size() {
        return this.connectedNodes.size();
    }

    @Override
    public void close() {
        assert (Transports.assertNotTransportThread("Closing ConnectionManager"));
        if (this.closing.compareAndSet(false, true)) {
            this.connectingRefCounter.decRef();
            try {
                this.closeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    private void internalOpenConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        this.transport.openConnection(node, connectionProfile, listener.map(connection -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection success"));
            try {
                this.connectionListener.onConnectionOpened((Transport.Connection)connection);
            }
            finally {
                connection.addCloseListener(ActionListener.wrap(() -> this.connectionListener.onConnectionClosed((Transport.Connection)connection)));
            }
            if (connection.isClosed()) {
                throw new ConnectTransportException(node, "a channel closed while connecting");
            }
            return connection;
        }));
    }

    private void failConnectionListeners(DiscoveryNode node, RunOnce releaseOnce, Exception e, CompletableFuture<Void> expectedListener) {
        CompletableFuture future = (CompletableFuture)this.pendingConnections.remove(node);
        releaseOnce.run();
        if (future != null) {
            assert (future == expectedListener) : "Listener in pending map is different than the expected listener";
            future.completeExceptionally(e);
        }
    }
}

