/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.TransportStatus;

public class Header {
    private static final String RESPONSE_NAME = "NO_ACTION_NAME_FOR_RESPONSES";
    private final int networkMessageSize;
    private final Version version;
    private final long requestId;
    private final byte status;
    String actionName;
    boolean bwcNeedsToReadVariableHeader = true;

    Header(int networkMessageSize, long requestId, byte status, Version version) {
        this.networkMessageSize = networkMessageSize;
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public int getNetworkMessageSize() {
        return this.networkMessageSize;
    }

    Version getVersion() {
        return this.version;
    }

    long getRequestId() {
        return this.requestId;
    }

    byte getStatus() {
        return this.status;
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isCompressed() {
        return TransportStatus.isCompress(this.status);
    }

    public String getActionName() {
        return this.actionName;
    }

    boolean needsToReadVariableHeader() {
        return this.bwcNeedsToReadVariableHeader;
    }

    void finishParsingHeader(StreamInput input) throws IOException {
        ThreadContext.bwcReadHeaders(input);
        this.bwcNeedsToReadVariableHeader = false;
        if (this.isRequest()) {
            if (this.version.before(Version.V_4_3_0)) {
                input.readStringArray();
            }
            this.actionName = input.readString();
        } else {
            this.actionName = RESPONSE_NAME;
        }
    }

    public String toString() {
        return "Header{" + this.networkMessageSize + "}{" + String.valueOf(this.version) + "}{" + this.requestId + "}{" + this.isRequest() + "}{" + this.isError() + "}{" + this.isHandshake() + "}{" + this.isCompressed() + "}{" + this.actionName + "}";
    }
}

