/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import io.crate.protocols.postgres.PgClientFactory;
import io.crate.replication.logical.metadata.ConnectionInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteCluster;
import org.elasticsearch.transport.TransportService;

public class RemoteClusters
implements Closeable {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final Map<String, RemoteCluster> remoteClusters = new HashMap<String, RemoteCluster>();
    private final PgClientFactory pgClientFactory;
    private boolean closed;

    public RemoteClusters(Settings settings, ThreadPool threadPool, PgClientFactory pgClientFactory, TransportService transportService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.pgClientFactory = pgClientFactory;
        this.transportService = transportService;
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close(this.remoteClusters.values());
        this.remoteClusters.clear();
        this.closed = true;
    }

    public synchronized Client getClient(String subscriptionName) {
        if (this.closed) {
            throw new AlreadyClosedException("RemoteClusters is closed");
        }
        RemoteCluster remoteCluster = this.remoteClusters.get(subscriptionName);
        if (remoteCluster == null) {
            throw new NoSuchRemoteClusterException(subscriptionName);
        }
        return remoteCluster.client();
    }

    public synchronized CompletableFuture<Client> connect(String name, ConnectionInfo connectionInfo) {
        if (this.closed) {
            return CompletableFuture.failedFuture(new AlreadyClosedException("RemoteClusters is closed"));
        }
        RemoteCluster remoteCluster = this.remoteClusters.get(name);
        if (remoteCluster == null) {
            remoteCluster = new RemoteCluster(name, this.settings, connectionInfo, this.pgClientFactory, this.threadPool, this.transportService);
            this.remoteClusters.put(name, remoteCluster);
        }
        CompletableFuture<Client> clientFuture = remoteCluster.connectAndGetClient();
        return clientFuture.whenComplete((c, err) -> {
            if (err != null) {
                this.remove(name);
            }
        });
    }

    public synchronized void remove(String subscriptionName) {
        RemoteCluster remoteCluster = this.remoteClusters.remove(subscriptionName);
        if (remoteCluster != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{remoteCluster});
        }
    }
}

