/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.common.collections.Sets;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.concurrent.CountDown;
import io.crate.protocols.ConnectionStats;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.InboundHandler;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportHandshaker;
import org.elasticsearch.transport.TransportKeepAlive;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.Transports;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class TcpTransport
extends AbstractLifecycleComponent
implements Transport {
    public static final int BYTES_NEEDED_FOR_MESSAGE_SIZE = 6;
    private static final long THIRTY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() * 0.3);
    final StatsTracker statsTracker = new StatsTracker();
    private static final int LIMIT_LOCAL_PORTS_COUNT = 6;
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final Settings settings;
    private final Version version;
    protected final ThreadPool threadPool;
    protected final PageCacheRecycler pageCacheRecycler;
    protected final NetworkService networkService;
    private final CircuitBreakerService circuitBreakerService;
    private final List<CloseableChannel> serverChannels = new ArrayList<CloseableChannel>();
    private final Set<CloseableChannel> acceptedChannels = Sets.newConcurrentHashSet();
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile BoundTransportAddress boundAddress;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final OutboundHandler outboundHandler;
    private final InboundHandler inboundHandler;
    private final Transport.ResponseHandlers responseHandlers = new Transport.ResponseHandlers();
    private final Transport.RequestHandlers requestHandlers = new Transport.RequestHandlers();
    private final AtomicLong outboundConnectionCount = new AtomicLong();
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::([\\d\\-]*))?$");

    public TcpTransport(Settings settings, Version version, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        this.settings = settings;
        this.version = version;
        this.threadPool = threadPool;
        this.pageCacheRecycler = pageCacheRecycler;
        this.circuitBreakerService = circuitBreakerService;
        this.networkService = networkService;
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        BigArrays bigArrays = new BigArrays(pageCacheRecycler, circuitBreakerService, "in_flight_requests");
        this.outboundHandler = new OutboundHandler(nodeName, version, this.statsTracker, threadPool, bigArrays);
        this.handshaker = new TransportHandshaker(version, threadPool, (node, channel, requestId, v) -> this.outboundHandler.sendRequest(node, channel, requestId, "internal:tcp/handshake", new TransportHandshaker.HandshakeRequest(version), TransportRequestOptions.EMPTY, v, false, true));
        this.keepAlive = new TransportKeepAlive(threadPool, this.outboundHandler::sendBytes);
        this.inboundHandler = new InboundHandler(threadPool, this.outboundHandler, namedWriteableRegistry, this.handshaker, this.keepAlive, this.requestHandlers, this.responseHandlers);
    }

    public Version getVersion() {
        return this.version;
    }

    public StatsTracker getStatsTracker() {
        return this.statsTracker;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Supplier<CircuitBreaker> getInflightBreaker() {
        return () -> this.circuitBreakerService.getBreaker("in_flight_requests");
    }

    @Override
    protected void doStart() {
    }

    @Override
    public synchronized void setMessageListener(TransportMessageListener listener) {
        this.outboundHandler.setMessageListener(listener);
        this.inboundHandler.setMessageListener(listener);
    }

    @Override
    public void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.inboundHandler.setSlowLogThreshold(slowLogThreshold);
    }

    protected ConnectionProfile maybeOverrideConnectionProfile(ConnectionProfile connectionProfile) {
        return connectionProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        Objects.requireNonNull(profile, "connection profile cannot be null");
        if (node == null) {
            throw new ConnectTransportException(null, "can't open connection to a null node");
        }
        ConnectionProfile finalProfile = this.maybeOverrideConnectionProfile(profile);
        this.closeLock.readLock().lock();
        try {
            this.ensureOpen();
            this.initiateConnection(node, finalProfile, listener);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private List<CloseableChannel> initiateConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        int numConnections = connectionProfile.getNumConnections();
        assert (numConnections > 0) : "A connection profile must be configured with at least one connection";
        ArrayList<CloseableChannel> channels = new ArrayList<CloseableChannel>(numConnections);
        ArrayList<ChannelFuture> connectFutures = new ArrayList<ChannelFuture>(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            try {
                ConnectResult initiateChannel = this.initiateChannel(node);
                CloseableChannel channel = initiateChannel.channel();
                this.logger.trace(() -> new ParameterizedMessage("Tcp transport client channel opened: {}", (Object)channel));
                channels.add(channel);
                connectFutures.add(initiateChannel.connectFuture());
                continue;
            }
            catch (ConnectTransportException e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure(e);
                return channels;
            }
            catch (Exception e) {
                CloseableChannel.closeChannels(channels, false);
                listener.onFailure(new ConnectTransportException(node, "general node connection failure", e));
                return channels;
            }
        }
        ChannelsConnectedListener channelsConnectedListener = new ChannelsConnectedListener(node, connectionProfile, channels, new ThreadedActionListener<Transport.Connection>(this.logger, this.threadPool, "generic", listener, false));
        for (ChannelFuture connectFuture : connectFutures) {
            connectFuture.addListener(f -> {
                if (f.isSuccess()) {
                    channelsConnectedListener.onResponse(null);
                } else {
                    channelsConnectedListener.onFailure(Exceptions.toException((Throwable)f.cause()));
                }
            });
        }
        TimeValue connectTimeout = connectionProfile.getConnectTimeout();
        this.threadPool.schedule(channelsConnectedListener::onTimeout, connectTimeout, "generic");
        return channels;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public List<String> getDefaultSeedAddresses() {
        ArrayList<String> local = new ArrayList<String>();
        local.add("127.0.0.1");
        if (NetworkUtils.SUPPORTS_V6) {
            local.add("[::1]");
        }
        return local.stream().flatMap(address -> Arrays.stream(this.defaultPortRange()).limit(6L).mapToObj(port -> address + ":" + port)).toList();
    }

    protected void bindServer(Settings settings) {
        List<InetAddress> hostAddresses;
        List<String> transportBindHosts = TransportSettings.BIND_HOST.get(settings);
        List<String> bindHosts = transportBindHosts.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : transportBindHosts;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(bindHosts.toArray(Strings.EMPTY_ARRAY));
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host " + String.valueOf(bindHosts), e);
        }
        if (this.logger.isDebugEnabled()) {
            String[] addresses = new String[hostAddresses.size()];
            for (int i = 0; i < hostAddresses.size(); ++i) {
                addresses[i] = NetworkAddress.format(hostAddresses.get(i));
            }
            this.logger.debug("binding server bootstrap to: {}", (Object)addresses);
        }
        assert (hostAddresses.size() > 0);
        ArrayList<InetSocketAddress> boundAddresses = new ArrayList<InetSocketAddress>();
        for (InetAddress hostAddress : hostAddresses) {
            boundAddresses.add(this.bindToPort(hostAddress, TransportSettings.PORT.get(settings)));
        }
        this.boundAddress = this.createBoundTransportAddress(settings, boundAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress bindToPort(InetAddress hostAddress, String port) {
        PortsRange portsRange = new PortsRange(port);
        AtomicReference lastException = new AtomicReference();
        AtomicReference boundSocket = new AtomicReference();
        this.closeLock.writeLock().lock();
        try {
            if (!this.lifecycle.initialized() && !this.lifecycle.started()) {
                throw new IllegalStateException("transport has been stopped");
            }
            boolean success = portsRange.iterate(portNumber -> {
                try {
                    CloseableChannel channel = this.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.serverChannels.add(channel);
                    boundSocket.set(channel.getLocalAddress());
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            });
            if (!success) {
                throw new BindTransportException("Failed to bind to " + NetworkAddress.format(hostAddress, portsRange), (Throwable)lastException.get());
            }
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return (InetSocketAddress)boundSocket.get();
    }

    private BoundTransportAddress createBoundTransportAddress(Settings settings, List<InetSocketAddress> boundAddresses) {
        InetAddress publishInetAddress;
        String[] boundAddressesHostStrings = new String[boundAddresses.size()];
        TransportAddress[] transportBoundAddresses = new TransportAddress[boundAddresses.size()];
        for (int i = 0; i < boundAddresses.size(); ++i) {
            InetSocketAddress boundAddress = boundAddresses.get(i);
            boundAddressesHostStrings[i] = boundAddress.getHostString();
            transportBoundAddresses[i] = new TransportAddress(boundAddress);
        }
        List<String> publishHosts = TransportSettings.PUBLISH_HOST.get(settings);
        if (publishHosts.isEmpty()) {
            publishHosts = NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings);
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(publishHosts.toArray(Strings.EMPTY_ARRAY));
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = TcpTransport.resolvePublishPort(settings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        return new BoundTransportAddress(transportBoundAddresses, publishAddress);
    }

    public static int resolvePublishPort(Settings settings, List<InetSocketAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = TransportSettings.PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (InetSocketAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (InetSocketAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindTransportException("Failed to auto-resolve publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + TransportSettings.PORT.getKey() + " or " + TransportSettings.PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return TcpTransport.parse(address, this.defaultPortRange()[0]);
    }

    private int[] defaultPortRange() {
        String portRange = TransportSettings.PORT.get(this.settings);
        return new PortsRange(portRange).ports();
    }

    static TransportAddress[] parse(String hostPortString, int defaultPort) throws UnknownHostException {
        String host;
        Objects.requireNonNull(hostPortString);
        String portString = null;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid bracketed host/port range: " + hostPortString);
            }
            host = matcher.group(1);
            portString = matcher.group(2);
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                if (colonPos >= 0) {
                    throw new IllegalArgumentException("IPv6 addresses must be bracketed: " + hostPortString);
                }
            }
        }
        int port = portString == null || portString.isEmpty() ? defaultPort : Integer.parseInt(portString);
        return (TransportAddress[])Arrays.stream(InetAddress.getAllByName(host)).distinct().map(address -> new TransportAddress((InetAddress)address, port)).toArray(TransportAddress[]::new);
    }

    @Override
    protected final void doClose() {
    }

    @Override
    protected final void doStop() {
        this.closeLock.writeLock().lock();
        try {
            this.keepAlive.close();
            ActionListener<Void> closeFailLogger = ActionListener.wrap(c -> {}, e -> this.logger.warn(() -> new ParameterizedMessage("Error closing serverChannel", new Object[0]), (Throwable)e));
            this.serverChannels.forEach(c -> c.addCloseListener(closeFailLogger));
            CloseableChannel.closeChannels(this.serverChannels, true);
            this.serverChannels.clear();
            CloseableChannel.closeChannels(this.acceptedChannels, true);
            this.acceptedChannels.clear();
            this.stopInternal();
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    public void onException(CloseableChannel channel, Exception e) {
        TcpTransport.handleException(this.logger, channel, e, this.lifecycle, this.outboundHandler);
    }

    @VisibleForTesting
    static void handleException(Logger logger, CloseableChannel channel, Exception e, Lifecycle lifecycle, OutboundHandler outboundHandler) {
        if (!lifecycle.started()) {
            CloseableChannel.closeChannel(channel, false);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e)) {
            logger.debug(() -> new ParameterizedMessage("close connection exception caught on transport layer [{}], disconnecting from relevant node", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel, false);
        } else if (NetworkExceptionHelper.isConnectException(e)) {
            logger.debug(() -> new ParameterizedMessage("connect exception caught on transport layer [{}]", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel, false);
        } else if (e instanceof BindException) {
            logger.debug(() -> new ParameterizedMessage("bind exception caught on transport layer [{}]", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel, false);
        } else if (e instanceof CancelledKeyException) {
            logger.debug(() -> new ParameterizedMessage("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel, false);
        } else if (e instanceof HttpRequestOnTransportException) {
            if (channel.isOpen()) {
                ChannelFuture future = outboundHandler.sendBytes(channel, e.getMessage().getBytes(StandardCharsets.UTF_8));
                future.addListener(f -> {
                    if (f.isSuccess()) {
                        channel.close();
                    }
                });
            }
        } else if (e instanceof StreamCorruptedException) {
            logger.warn(() -> new ParameterizedMessage("{}, [{}], closing connection", (Object)e.getMessage(), (Object)channel));
            CloseableChannel.closeChannel(channel, false);
        } else {
            logger.warn(() -> new ParameterizedMessage("exception caught on transport layer [{}], closing connection", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel, false);
        }
    }

    protected void onServerException(CloseableChannel channel, Exception e) {
        if (e instanceof BindException) {
            this.logger.debug(() -> new ParameterizedMessage("bind exception from server channel caught on transport layer [{}]", (Object)channel), (Throwable)e);
        } else {
            this.logger.error((Message)new ParameterizedMessage("exception from server channel caught on transport layer [channel={}]", (Object)channel), (Throwable)e);
        }
    }

    protected void serverAcceptedChannel(CloseableChannel channel) {
        this.statsTracker.incrementOpenChannels();
        boolean addedOnThisCall = this.acceptedChannels.add(channel);
        assert (addedOnThisCall) : "Channel should only be added to accepted channel set once";
        channel.markAccessed(this.threadPool.relativeTimeInMillis());
        channel.addCloseListener(ActionListener.wrap(() -> {
            this.acceptedChannels.remove(channel);
            this.statsTracker.decrementOpenChannels();
        }));
        this.logger.trace(() -> new ParameterizedMessage("Tcp transport channel accepted: {}", (Object)channel));
    }

    protected abstract CloseableChannel bind(InetSocketAddress var1) throws IOException;

    protected abstract ConnectResult initiateChannel(DiscoveryNode var1) throws IOException;

    protected abstract void stopInternal();

    public void inboundMessage(CloseableChannel channel, InboundMessage message) {
        try {
            this.inboundHandler.inboundMessage(channel, message);
        }
        catch (Exception e) {
            this.onException(channel, e);
        }
    }

    public static int readMessageLength(BytesReference networkBytes) throws IOException {
        if (networkBytes.length() < 6) {
            return -1;
        }
        return TcpTransport.readHeaderBuffer(networkBytes);
    }

    private static int readHeaderBuffer(BytesReference headerBuffer) throws IOException {
        if (headerBuffer.get(0) != 69 || headerBuffer.get(1) != 83) {
            if (TcpTransport.appearsToBeHTTPRequest(headerBuffer)) {
                throw new HttpRequestOnTransportException("This is not a HTTP port");
            }
            if (TcpTransport.appearsToBeHTTPResponse(headerBuffer)) {
                throw new StreamCorruptedException("received HTTP response on transport port, ensure that transport port (not HTTP port) of a remote node is specified in the configuration");
            }
            String firstBytes = "(" + Integer.toHexString(headerBuffer.get(0) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(1) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(2) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(3) & 0xFF) + ")";
            if (TcpTransport.appearsToBeTLS(headerBuffer)) {
                throw new StreamCorruptedException("SSL/TLS request received but SSL/TLS is not enabled on this node, got " + firstBytes);
            }
            throw new StreamCorruptedException("invalid internal transport message format, got " + firstBytes);
        }
        int messageLength = headerBuffer.getInt(2);
        if (messageLength == -1) {
            return 0;
        }
        if (messageLength <= 0) {
            throw new StreamCorruptedException("invalid data length: " + messageLength);
        }
        if ((long)messageLength > THIRTY_PER_HEAP_SIZE) {
            throw new IllegalArgumentException("transport content length received [" + String.valueOf(new ByteSizeValue(messageLength)) + "] exceeded [" + String.valueOf(new ByteSizeValue(THIRTY_PER_HEAP_SIZE)) + "]");
        }
        return messageLength;
    }

    private static boolean appearsToBeHTTPRequest(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "GET") || TcpTransport.bufferStartsWith(headerBuffer, "POST") || TcpTransport.bufferStartsWith(headerBuffer, "PUT") || TcpTransport.bufferStartsWith(headerBuffer, "HEAD") || TcpTransport.bufferStartsWith(headerBuffer, "DELETE") || TcpTransport.bufferStartsWith(headerBuffer, "OPTION") || TcpTransport.bufferStartsWith(headerBuffer, "PATCH") || TcpTransport.bufferStartsWith(headerBuffer, "TRACE");
    }

    private static boolean appearsToBeHTTPResponse(BytesReference headerBuffer) {
        return TcpTransport.bufferStartsWith(headerBuffer, "HTTP");
    }

    private static boolean appearsToBeTLS(BytesReference headerBuffer) {
        return headerBuffer.get(0) == 22 && headerBuffer.get(1) == 3;
    }

    private static boolean bufferStartsWith(BytesReference buffer, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.get(i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public void executeHandshake(DiscoveryNode node, CloseableChannel channel, ConnectionProfile profile, ActionListener<Version> listener) {
        long requestId = this.responseHandlers.newRequestId();
        this.handshaker.sendHandshake(requestId, node, channel, profile.getHandshakeTimeout(), listener);
    }

    final TransportKeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    final int getNumPendingHandshakes() {
        return this.handshaker.getNumPendingHandshakes();
    }

    final long getNumHandshakes() {
        return this.handshaker.getNumHandshakes();
    }

    private void ensureOpen() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("transport has been stopped");
        }
    }

    @Override
    public final ConnectionStats getStats() {
        return this.statsTracker.stats();
    }

    @Override
    public final Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    @Override
    public final Transport.RequestHandlers getRequestHandlers() {
        return this.requestHandlers;
    }

    public OutboundHandler outboundHandler() {
        return this.outboundHandler;
    }

    public record ConnectResult(CloseableChannel channel, ChannelFuture connectFuture) {
    }

    private final class ChannelsConnectedListener
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final ConnectionProfile connectionProfile;
        private final List<CloseableChannel> channels;
        private final ActionListener<Transport.Connection> listener;
        private final CountDown countDown;

        private ChannelsConnectedListener(DiscoveryNode node, ConnectionProfile connectionProfile, List<CloseableChannel> channels, ActionListener<Transport.Connection> listener) {
            this.node = node;
            this.connectionProfile = connectionProfile;
            this.channels = channels;
            this.listener = listener;
            this.countDown = new CountDown(channels.size());
        }

        @Override
        public void onResponse(Void v) {
            if (this.countDown.countDown()) {
                CloseableChannel handshakeChannel = this.channels.get(0);
                try {
                    TcpTransport.this.executeHandshake(this.node, handshakeChannel, this.connectionProfile, ActionListener.wrap(version -> {
                        long connectionId = TcpTransport.this.outboundConnectionCount.incrementAndGet();
                        TcpTransport.this.logger.debug("opened transport connection [{}] to [{}] using channels [{}]", (Object)connectionId, (Object)this.node, this.channels);
                        NodeChannels nodeChannels = new NodeChannels(this.node, this.channels, this.connectionProfile, (Version)version);
                        long relativeMillisTime = TcpTransport.this.threadPool.relativeTimeInMillis();
                        nodeChannels.channels.forEach(ch -> {
                            ch.markAccessed(relativeMillisTime);
                            ch.addCloseListener(ActionListener.wrap(nodeChannels::close));
                        });
                        TcpTransport.this.keepAlive.registerNodeConnection(nodeChannels.channels, this.connectionProfile);
                        nodeChannels.addCloseListener(new ChannelCloseLogger(this.node, connectionId, relativeMillisTime));
                        this.listener.onResponse(nodeChannels);
                    }, e -> this.closeAndFail(e instanceof ConnectTransportException ? e : new ConnectTransportException(this.node, "general node connection failure", (Throwable)e))));
                }
                catch (Exception ex) {
                    this.closeAndFail(ex);
                }
            }
        }

        @Override
        public void onFailure(Exception ex) {
            if (this.countDown.fastForward()) {
                this.closeAndFail(new ConnectTransportException(this.node, "connect_exception", ex));
            }
        }

        public void onTimeout() {
            if (this.countDown.fastForward()) {
                this.closeAndFail(new ConnectTransportException(this.node, "connect_timeout[" + String.valueOf(this.connectionProfile.getConnectTimeout()) + "]"));
            }
        }

        private void closeAndFail(Exception e) {
            try {
                CloseableChannel.closeChannels(this.channels, false);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            finally {
                this.listener.onFailure(e);
            }
        }
    }

    public static class HttpRequestOnTransportException
    extends ElasticsearchException {
        public HttpRequestOnTransportException(String msg) {
            super(msg, new Object[0]);
        }

        @Override
        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        public HttpRequestOnTransportException(StreamInput in) throws IOException {
            super(in);
        }
    }

    private class ChannelCloseLogger
    implements ActionListener<Void> {
        private final DiscoveryNode node;
        private final long connectionId;
        private final long openTimeMillis;

        ChannelCloseLogger(DiscoveryNode node, long connectionId, long openTimeMillis) {
            this.node = node;
            this.connectionId = connectionId;
            this.openTimeMillis = openTimeMillis;
        }

        @Override
        public void onResponse(Void ignored) {
            long closeTimeMillis = TcpTransport.this.threadPool.relativeTimeInMillis();
            TcpTransport.this.logger.debug("closed transport connection [{}] to [{}] with age [{}ms]", (Object)this.connectionId, (Object)this.node, (Object)(closeTimeMillis - this.openTimeMillis));
        }

        @Override
        public void onFailure(Exception e) {
            assert (false) : e;
        }
    }

    public final class NodeChannels
    extends CloseableConnection {
        private final Map<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle> typeMapping;
        private final List<CloseableChannel> channels;
        private final DiscoveryNode node;
        private final Version version;
        private final boolean compress;
        private final AtomicBoolean isClosing = new AtomicBoolean(false);

        NodeChannels(DiscoveryNode node, List<CloseableChannel> channels, ConnectionProfile connectionProfile, Version handshakeVersion) {
            this.node = node;
            this.channels = Collections.unmodifiableList(channels);
            assert (channels.size() == connectionProfile.getNumConnections()) : "expected channels size to be == " + connectionProfile.getNumConnections() + " but was: [" + channels.size() + "]";
            this.typeMapping = new EnumMap<TransportRequestOptions.Type, ConnectionProfile.ConnectionTypeHandle>(TransportRequestOptions.Type.class);
            for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile.getHandles()) {
                for (TransportRequestOptions.Type type : handle.getTypes()) {
                    this.typeMapping.put(type, handle);
                }
            }
            this.version = handshakeVersion;
            this.compress = connectionProfile.getCompressionEnabled();
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        public List<CloseableChannel> getChannels() {
            return this.channels;
        }

        public CloseableChannel channel(TransportRequestOptions.Type type) {
            ConnectionProfile.ConnectionTypeHandle connectionTypeHandle = this.typeMapping.get((Object)type);
            if (connectionTypeHandle == null) {
                throw new IllegalArgumentException("no type channel for [" + String.valueOf((Object)type) + "]");
            }
            return connectionTypeHandle.getChannel(this.channels);
        }

        @Override
        public void close() {
            if (this.isClosing.compareAndSet(false, true)) {
                try {
                    boolean block = TcpTransport.this.lifecycle.stopped() && !Transports.isTransportThread(Thread.currentThread());
                    CloseableChannel.closeChannels(this.channels, block);
                }
                finally {
                    super.close();
                }
            }
        }

        @Override
        public DiscoveryNode getNode() {
            return this.node;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            if (this.isClosing.get()) {
                throw new NodeNotConnectedException(this.node, "connection already closed");
            }
            CloseableChannel channel = this.channel(options.type());
            TcpTransport.this.outboundHandler.sendRequest(this.node, channel, requestId, action, request, options, this.getVersion(), this.compress, false);
        }

        public String toString() {
            return "NodeChannels{channels=" + String.valueOf(this.channels) + ", node=" + String.valueOf(this.node) + ", version=" + String.valueOf(this.version) + ", isClosing=" + String.valueOf(this.isClosing) + "}";
        }
    }
}

