/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.collections.Sets;
import io.crate.common.unit.TimeValue;
import io.netty.channel.ChannelFuture;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;

final class TransportKeepAlive
implements Closeable {
    static final int PING_DATA_SIZE = -1;
    private static final byte[] PING_MESSAGE = new byte[]{69, 83, -1, -1, -1, -1};
    private final Logger logger = LogManager.getLogger(TransportKeepAlive.class);
    private final CounterMetric successfulPings = new CounterMetric();
    private final CounterMetric failedPings = new CounterMetric();
    private final ConcurrentMap<TimeValue, ScheduledPing> pingIntervals = new ConcurrentHashMap<TimeValue, ScheduledPing>();
    private final Lifecycle lifecycle = new Lifecycle();
    private final ThreadPool threadPool;
    private final BiFunction<CloseableChannel, byte[], ChannelFuture> pingSender;

    TransportKeepAlive(ThreadPool threadPool, BiFunction<CloseableChannel, byte[], ChannelFuture> pingSender) {
        this.threadPool = threadPool;
        this.pingSender = pingSender;
        this.lifecycle.moveToStarted();
    }

    void registerNodeConnection(List<CloseableChannel> nodeChannels, ConnectionProfile connectionProfile) {
        TimeValue pingInterval = connectionProfile.getPingInterval();
        if (pingInterval.millis() < 0L) {
            return;
        }
        ScheduledPing scheduledPing = this.pingIntervals.computeIfAbsent(pingInterval, x$0 -> new ScheduledPing((TimeValue)x$0));
        scheduledPing.ensureStarted();
        for (CloseableChannel channel : nodeChannels) {
            scheduledPing.addChannel(channel);
            channel.addCloseListener(ActionListener.wrap(() -> scheduledPing.removeChannel(channel)));
        }
    }

    void receiveKeepAlive(CloseableChannel channel) {
        if (channel.isServerChannel()) {
            this.sendPing(channel);
        }
    }

    long successfulPingCount() {
        return this.successfulPings.count();
    }

    long failedPingCount() {
        return this.failedPings.count();
    }

    private void sendPing(CloseableChannel channel) {
        ChannelFuture future = this.pingSender.apply(channel, PING_MESSAGE);
        future.addListener(f -> {
            if (f.isSuccess()) {
                this.successfulPings.inc();
            } else {
                Throwable e = f.cause();
                if (channel.isOpen()) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] failed to send transport ping", (Object)channel), e);
                    this.failedPings.inc();
                } else {
                    this.logger.trace(() -> new ParameterizedMessage("[{}] failed to send transport ping (channel closed)", (Object)channel), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            this.lifecycle.moveToStopped();
            this.lifecycle.moveToClosed();
        }
    }

    private class ScheduledPing
    extends AbstractLifecycleRunnable {
        private final TimeValue pingInterval;
        private final Set<CloseableChannel> channels;
        private final AtomicBoolean isStarted;
        private volatile long lastPingRelativeMillis;

        private ScheduledPing(TimeValue pingInterval) {
            super(TransportKeepAlive.this.lifecycle, TransportKeepAlive.this.logger);
            this.channels = Sets.newConcurrentHashSet();
            this.isStarted = new AtomicBoolean(false);
            this.pingInterval = pingInterval;
            this.lastPingRelativeMillis = TransportKeepAlive.this.threadPool.relativeTimeInMillis();
        }

        void ensureStarted() {
            if (!this.isStarted.get() && this.isStarted.compareAndSet(false, true)) {
                TransportKeepAlive.this.threadPool.schedule(this, this.pingInterval, "generic");
            }
        }

        void addChannel(CloseableChannel channel) {
            this.channels.add(channel);
        }

        void removeChannel(CloseableChannel channel) {
            this.channels.remove(channel);
        }

        @Override
        protected void doRunInLifecycle() {
            for (CloseableChannel channel : this.channels) {
                if (!this.needsKeepAlivePing(channel)) continue;
                TransportKeepAlive.this.sendPing(channel);
            }
            this.lastPingRelativeMillis = TransportKeepAlive.this.threadPool.relativeTimeInMillis();
        }

        @Override
        protected void onAfterInLifecycle() {
            TransportKeepAlive.this.threadPool.scheduleUnlessShuttingDown(this.pingInterval, "generic", this);
        }

        @Override
        public void onFailure(Exception e) {
            TransportKeepAlive.this.logger.warn("failed to send ping transport message", (Throwable)e);
        }

        private boolean needsKeepAlivePing(CloseableChannel channel) {
            long accessedDelta = channel.lastAccessedTime() - this.lastPingRelativeMillis;
            return accessedDelta <= 0L;
        }
    }
}

