/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.crate.common.exceptions.Exceptions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.InboundAggregator;
import org.elasticsearch.transport.InboundDecoder;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

public final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;
    private final InboundPipeline pipeline;

    public Netty4MessageChannelHandler(PageCacheRecycler recycler, Netty4Transport transport) {
        this.transport = transport;
        ThreadPool threadPool = transport.getThreadPool();
        Transport.RequestHandlers requestHandlers = transport.getRequestHandlers();
        this.pipeline = new InboundPipeline(transport.getStatsTracker(), threadPool::relativeTimeInMillis, new InboundDecoder(recycler), new InboundAggregator(transport.getInflightBreaker(), requestHandlers::getHandler), transport::inboundMessage);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (Transports.assertTransportThread());
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + String.valueOf(msg.getClass());
        ByteBuf buffer = (ByteBuf)msg;
        CloseableChannel channel = (CloseableChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        BytesReference wrapped = Netty4Utils.toBytesReference(buffer);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(wrapped, () -> ((ByteBuf)buffer).release());){
            this.pipeline.handleBytes(channel, reference);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable throwable = cause;
        Exceptions.maybeDieOnAnotherThread((Throwable)throwable);
        Throwable unwrapped = Exceptions.firstCause((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        CloseableChannel tcpChannel = (CloseableChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Releasables.closeIgnoringException(this.pipeline);
        super.channelInactive(ctx);
    }
}

